package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReplicaSetSpecBuilder extends ReplicaSetSpecFluentImpl<ReplicaSetSpecBuilder> implements VisitableBuilder<ReplicaSetSpec,io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecBuilder>{
  public ReplicaSetSpecBuilder() {
    this(false);
  }
  public ReplicaSetSpecBuilder(Boolean validationEnabled) {
    this(new ReplicaSetSpec(), validationEnabled);
  }
  public ReplicaSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicaSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ReplicaSetSpec(), validationEnabled);
  }
  public ReplicaSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpec instance) {
    this(fluent, instance, false);
  }
  public ReplicaSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMinReadySeconds(instance.getMinReadySeconds()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withTemplate(instance.getTemplate()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReplicaSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpec instance) {
    this(instance,false);
  }
  public ReplicaSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMinReadySeconds(instance.getMinReadySeconds()); 
    this.withReplicas(instance.getReplicas()); 
    this.withSelector(instance.getSelector()); 
    this.withTemplate(instance.getTemplate()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpec build() {
    ReplicaSetSpec buildable = new ReplicaSetSpec(fluent.getMinReadySeconds(),fluent.getReplicas(),fluent.getSelector(),fluent.getTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}