package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReplicaSetListBuilder extends ReplicaSetListFluentImpl<ReplicaSetListBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.ReplicaSetList,io.fabric8.kubernetes.api.model.extensions.ReplicaSetListBuilder>{
  public ReplicaSetListBuilder() {
    this(false);
  }
  public ReplicaSetListBuilder(Boolean validationEnabled) {
    this(new ReplicaSetList(), validationEnabled);
  }
  public ReplicaSetListBuilder(ReplicaSetListFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicaSetListBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ReplicaSetList(), validationEnabled);
  }
  public ReplicaSetListBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetListFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.ReplicaSetList instance) {
    this(fluent, instance, false);
  }
  public ReplicaSetListBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetListFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.ReplicaSetList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReplicaSetListBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetList instance) {
    this(instance,false);
  }
  public ReplicaSetListBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.ReplicaSetListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.ReplicaSetList build() {
    ReplicaSetList buildable = new ReplicaSetList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}