package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReplicaSetConditionBuilder extends ReplicaSetConditionFluentImpl<ReplicaSetConditionBuilder> implements VisitableBuilder<ReplicaSetCondition,io.fabric8.kubernetes.api.model.extensions.ReplicaSetConditionBuilder>{
  public ReplicaSetConditionBuilder() {
    this(false);
  }
  public ReplicaSetConditionBuilder(Boolean validationEnabled) {
    this(new ReplicaSetCondition(), validationEnabled);
  }
  public ReplicaSetConditionBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicaSetConditionBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ReplicaSetCondition(), validationEnabled);
  }
  public ReplicaSetConditionBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.ReplicaSetCondition instance) {
    this(fluent, instance, false);
  }
  public ReplicaSetConditionBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.ReplicaSetCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReplicaSetConditionBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetCondition instance) {
    this(instance,false);
  }
  public ReplicaSetConditionBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.ReplicaSetConditionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.ReplicaSetCondition build() {
    ReplicaSetCondition buildable = new ReplicaSetCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}