package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkPolicyStatusBuilder extends NetworkPolicyStatusFluentImpl<NetworkPolicyStatusBuilder> implements VisitableBuilder<NetworkPolicyStatus,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyStatusBuilder>{
  public NetworkPolicyStatusBuilder() {
    this(false);
  }
  public NetworkPolicyStatusBuilder(Boolean validationEnabled) {
    this(new NetworkPolicyStatus(), validationEnabled);
  }
  public NetworkPolicyStatusBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkPolicyStatusBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NetworkPolicyStatus(), validationEnabled);
  }
  public NetworkPolicyStatusBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyStatus instance) {
    this(fluent, instance, false);
  }
  public NetworkPolicyStatusBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetworkPolicyStatusBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyStatus instance) {
    this(instance,false);
  }
  public NetworkPolicyStatusBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.NetworkPolicyStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicyStatus build() {
    NetworkPolicyStatus buildable = new NetworkPolicyStatus(fluent.getConditions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}