package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkPolicySpecBuilder extends NetworkPolicySpecFluentImpl<NetworkPolicySpecBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpec,NetworkPolicySpecBuilder>{
  public NetworkPolicySpecBuilder() {
    this(false);
  }
  public NetworkPolicySpecBuilder(Boolean validationEnabled) {
    this(new NetworkPolicySpec(), validationEnabled);
  }
  public NetworkPolicySpecBuilder(NetworkPolicySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkPolicySpecBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NetworkPolicySpec(), validationEnabled);
  }
  public NetworkPolicySpecBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpec instance) {
    this(fluent, instance, false);
  }
  public NetworkPolicySpecBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEgress(instance.getEgress()); 
    fluent.withIngress(instance.getIngress()); 
    fluent.withPodSelector(instance.getPodSelector()); 
    fluent.withPolicyTypes(instance.getPolicyTypes()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetworkPolicySpecBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpec instance) {
    this(instance,false);
  }
  public NetworkPolicySpecBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withEgress(instance.getEgress()); 
    this.withIngress(instance.getIngress()); 
    this.withPodSelector(instance.getPodSelector()); 
    this.withPolicyTypes(instance.getPolicyTypes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpec build() {
    NetworkPolicySpec buildable = new NetworkPolicySpec(fluent.getEgress(),fluent.getIngress(),fluent.getPodSelector(),fluent.getPolicyTypes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}