package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkPolicyIngressRuleBuilder extends NetworkPolicyIngressRuleFluentImpl<NetworkPolicyIngressRuleBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule,NetworkPolicyIngressRuleBuilder>{
  public NetworkPolicyIngressRuleBuilder() {
    this(false);
  }
  public NetworkPolicyIngressRuleBuilder(Boolean validationEnabled) {
    this(new NetworkPolicyIngressRule(), validationEnabled);
  }
  public NetworkPolicyIngressRuleBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkPolicyIngressRuleBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NetworkPolicyIngressRule(), validationEnabled);
  }
  public NetworkPolicyIngressRuleBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule instance) {
    this(fluent, instance, false);
  }
  public NetworkPolicyIngressRuleBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFrom(instance.getFrom()); 
    fluent.withPorts(instance.getPorts()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetworkPolicyIngressRuleBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule instance) {
    this(instance,false);
  }
  public NetworkPolicyIngressRuleBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withFrom(instance.getFrom()); 
    this.withPorts(instance.getPorts()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule build() {
    NetworkPolicyIngressRule buildable = new NetworkPolicyIngressRule(fluent.getFrom(),fluent.getPorts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}