package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkPolicyEgressRuleBuilder extends NetworkPolicyEgressRuleFluentImpl<NetworkPolicyEgressRuleBuilder> implements VisitableBuilder<NetworkPolicyEgressRule,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder>{
  public NetworkPolicyEgressRuleBuilder() {
    this(false);
  }
  public NetworkPolicyEgressRuleBuilder(Boolean validationEnabled) {
    this(new NetworkPolicyEgressRule(), validationEnabled);
  }
  public NetworkPolicyEgressRuleBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkPolicyEgressRuleBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NetworkPolicyEgressRule(), validationEnabled);
  }
  public NetworkPolicyEgressRuleBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule instance) {
    this(fluent, instance, false);
  }
  public NetworkPolicyEgressRuleBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPorts(instance.getPorts()); 
    fluent.withTo(instance.getTo()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetworkPolicyEgressRuleBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule instance) {
    this(instance,false);
  }
  public NetworkPolicyEgressRuleBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withPorts(instance.getPorts()); 
    this.withTo(instance.getTo()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule build() {
    NetworkPolicyEgressRule buildable = new NetworkPolicyEgressRule(fluent.getPorts(),fluent.getTo());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}