package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkPolicyBuilder extends NetworkPolicyFluentImpl<NetworkPolicyBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.NetworkPolicy,NetworkPolicyBuilder>{
  public NetworkPolicyBuilder() {
    this(false);
  }
  public NetworkPolicyBuilder(Boolean validationEnabled) {
    this(new NetworkPolicy(), validationEnabled);
  }
  public NetworkPolicyBuilder(NetworkPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkPolicyBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NetworkPolicy(), validationEnabled);
  }
  public NetworkPolicyBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.NetworkPolicy instance) {
    this(fluent, instance, false);
  }
  public NetworkPolicyBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.NetworkPolicy instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetworkPolicyBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicy instance) {
    this(instance,false);
  }
  public NetworkPolicyBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicy instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.NetworkPolicyFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicy build() {
    NetworkPolicy buildable = new NetworkPolicy(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}