package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressStatusBuilder extends IngressStatusFluentImpl<IngressStatusBuilder> implements VisitableBuilder<IngressStatus,io.fabric8.kubernetes.api.model.extensions.IngressStatusBuilder>{
  public IngressStatusBuilder() {
    this(false);
  }
  public IngressStatusBuilder(Boolean validationEnabled) {
    this(new IngressStatus(), validationEnabled);
  }
  public IngressStatusBuilder(io.fabric8.kubernetes.api.model.extensions.IngressStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressStatusBuilder(io.fabric8.kubernetes.api.model.extensions.IngressStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IngressStatus(), validationEnabled);
  }
  public IngressStatusBuilder(io.fabric8.kubernetes.api.model.extensions.IngressStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.IngressStatus instance) {
    this(fluent, instance, false);
  }
  public IngressStatusBuilder(io.fabric8.kubernetes.api.model.extensions.IngressStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.IngressStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLoadBalancer(instance.getLoadBalancer()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressStatusBuilder(io.fabric8.kubernetes.api.model.extensions.IngressStatus instance) {
    this(instance,false);
  }
  public IngressStatusBuilder(io.fabric8.kubernetes.api.model.extensions.IngressStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLoadBalancer(instance.getLoadBalancer()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.IngressStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.IngressStatus build() {
    IngressStatus buildable = new IngressStatus(fluent.getLoadBalancer());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}