package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressBackendBuilder extends IngressBackendFluentImpl<IngressBackendBuilder> implements VisitableBuilder<IngressBackend,io.fabric8.kubernetes.api.model.extensions.IngressBackendBuilder>{
  public IngressBackendBuilder() {
    this(false);
  }
  public IngressBackendBuilder(Boolean validationEnabled) {
    this(new IngressBackend(), validationEnabled);
  }
  public IngressBackendBuilder(io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressBackendBuilder(io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IngressBackend(), validationEnabled);
  }
  public IngressBackendBuilder(io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.IngressBackend instance) {
    this(fluent, instance, false);
  }
  public IngressBackendBuilder(io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.IngressBackend instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withResource(instance.getResource()); 
    fluent.withServiceName(instance.getServiceName()); 
    fluent.withServicePort(instance.getServicePort()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressBackendBuilder(io.fabric8.kubernetes.api.model.extensions.IngressBackend instance) {
    this(instance,false);
  }
  public IngressBackendBuilder(io.fabric8.kubernetes.api.model.extensions.IngressBackend instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withResource(instance.getResource()); 
    this.withServiceName(instance.getServiceName()); 
    this.withServicePort(instance.getServicePort()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.IngressBackend build() {
    IngressBackend buildable = new IngressBackend(fluent.getResource(),fluent.getServiceName(),fluent.getServicePort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}