package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IPBlockBuilder extends IPBlockFluentImpl<IPBlockBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.IPBlock,io.fabric8.kubernetes.api.model.extensions.IPBlockBuilder>{
  public IPBlockBuilder() {
    this(false);
  }
  public IPBlockBuilder(Boolean validationEnabled) {
    this(new IPBlock(), validationEnabled);
  }
  public IPBlockBuilder(IPBlockFluent<?> fluent) {
    this(fluent, false);
  }
  public IPBlockBuilder(io.fabric8.kubernetes.api.model.extensions.IPBlockFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IPBlock(), validationEnabled);
  }
  public IPBlockBuilder(io.fabric8.kubernetes.api.model.extensions.IPBlockFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.IPBlock instance) {
    this(fluent, instance, false);
  }
  public IPBlockBuilder(io.fabric8.kubernetes.api.model.extensions.IPBlockFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.IPBlock instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCidr(instance.getCidr()); 
    fluent.withExcept(instance.getExcept()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IPBlockBuilder(io.fabric8.kubernetes.api.model.extensions.IPBlock instance) {
    this(instance,false);
  }
  public IPBlockBuilder(io.fabric8.kubernetes.api.model.extensions.IPBlock instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCidr(instance.getCidr()); 
    this.withExcept(instance.getExcept()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.IPBlockFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.IPBlock build() {
    IPBlock buildable = new IPBlock(fluent.getCidr(),fluent.getExcept());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}