package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPIngressRuleValueBuilder extends HTTPIngressRuleValueFluentImpl<HTTPIngressRuleValueBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue,io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueBuilder>{
  public HTTPIngressRuleValueBuilder() {
    this(false);
  }
  public HTTPIngressRuleValueBuilder(Boolean validationEnabled) {
    this(new HTTPIngressRuleValue(), validationEnabled);
  }
  public HTTPIngressRuleValueBuilder(HTTPIngressRuleValueFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPIngressRuleValueBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HTTPIngressRuleValue(), validationEnabled);
  }
  public HTTPIngressRuleValueBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue instance) {
    this(fluent, instance, false);
  }
  public HTTPIngressRuleValueBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPaths(instance.getPaths()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HTTPIngressRuleValueBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue instance) {
    this(instance,false);
  }
  public HTTPIngressRuleValueBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withPaths(instance.getPaths()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue build() {
    HTTPIngressRuleValue buildable = new HTTPIngressRuleValue(fluent.getPaths());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}