package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPIngressPathBuilder extends HTTPIngressPathFluentImpl<HTTPIngressPathBuilder> implements VisitableBuilder<HTTPIngressPath,io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathBuilder>{
  public HTTPIngressPathBuilder() {
    this(false);
  }
  public HTTPIngressPathBuilder(Boolean validationEnabled) {
    this(new HTTPIngressPath(), validationEnabled);
  }
  public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPIngressPathBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HTTPIngressPath(), validationEnabled);
  }
  public HTTPIngressPathBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath instance) {
    this(fluent, instance, false);
  }
  public HTTPIngressPathBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBackend(instance.getBackend()); 
    fluent.withPath(instance.getPath()); 
    fluent.withPathType(instance.getPathType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HTTPIngressPathBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath instance) {
    this(instance,false);
  }
  public HTTPIngressPathBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withBackend(instance.getBackend()); 
    this.withPath(instance.getPath()); 
    this.withPathType(instance.getPathType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath build() {
    HTTPIngressPath buildable = new HTTPIngressPath(fluent.getBackend(),fluent.getPath(),fluent.getPathType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}