package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentRollbackBuilder extends DeploymentRollbackFluentImpl<DeploymentRollbackBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.DeploymentRollback,io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackBuilder>{
  public DeploymentRollbackBuilder() {
    this(false);
  }
  public DeploymentRollbackBuilder(Boolean validationEnabled) {
    this(new DeploymentRollback(), validationEnabled);
  }
  public DeploymentRollbackBuilder(DeploymentRollbackFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentRollbackBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DeploymentRollback(), validationEnabled);
  }
  public DeploymentRollbackBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.DeploymentRollback instance) {
    this(fluent, instance, false);
  }
  public DeploymentRollbackBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.DeploymentRollback instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withRollbackTo(instance.getRollbackTo()); 
    fluent.withUpdatedAnnotations(instance.getUpdatedAnnotations()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DeploymentRollbackBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentRollback instance) {
    this(instance,false);
  }
  public DeploymentRollbackBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentRollback instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withRollbackTo(instance.getRollbackTo()); 
    this.withUpdatedAnnotations(instance.getUpdatedAnnotations()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.DeploymentRollback build() {
    DeploymentRollback buildable = new DeploymentRollback(fluent.getApiVersion(),fluent.getKind(),fluent.getName(),fluent.getRollbackTo(),fluent.getUpdatedAnnotations());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}