package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentListBuilder extends DeploymentListFluentImpl<DeploymentListBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.DeploymentList,io.fabric8.kubernetes.api.model.extensions.DeploymentListBuilder>{
  public DeploymentListBuilder() {
    this(false);
  }
  public DeploymentListBuilder(Boolean validationEnabled) {
    this(new DeploymentList(), validationEnabled);
  }
  public DeploymentListBuilder(DeploymentListFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentListBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DeploymentList(), validationEnabled);
  }
  public DeploymentListBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentListFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.DeploymentList instance) {
    this(fluent, instance, false);
  }
  public DeploymentListBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentListFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.DeploymentList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DeploymentListBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentList instance) {
    this(instance,false);
  }
  public DeploymentListBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.DeploymentListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.DeploymentList build() {
    DeploymentList buildable = new DeploymentList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}