package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentConditionBuilder extends DeploymentConditionFluentImpl<DeploymentConditionBuilder> implements VisitableBuilder<DeploymentCondition,io.fabric8.kubernetes.api.model.extensions.DeploymentConditionBuilder>{
  public DeploymentConditionBuilder() {
    this(false);
  }
  public DeploymentConditionBuilder(Boolean validationEnabled) {
    this(new DeploymentCondition(), validationEnabled);
  }
  public DeploymentConditionBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentConditionBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DeploymentCondition(), validationEnabled);
  }
  public DeploymentConditionBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.DeploymentCondition instance) {
    this(fluent, instance, false);
  }
  public DeploymentConditionBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.DeploymentCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withLastUpdateTime(instance.getLastUpdateTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DeploymentConditionBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentCondition instance) {
    this(instance,false);
  }
  public DeploymentConditionBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withLastUpdateTime(instance.getLastUpdateTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.DeploymentConditionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.DeploymentCondition build() {
    DeploymentCondition buildable = new DeploymentCondition(fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}