package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DaemonSetSpecBuilder extends DaemonSetSpecFluentImpl<DaemonSetSpecBuilder> implements VisitableBuilder<DaemonSetSpec,io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecBuilder>{
  public DaemonSetSpecBuilder() {
    this(false);
  }
  public DaemonSetSpecBuilder(Boolean validationEnabled) {
    this(new DaemonSetSpec(), validationEnabled);
  }
  public DaemonSetSpecBuilder(DaemonSetSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DaemonSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DaemonSetSpec(), validationEnabled);
  }
  public DaemonSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.DaemonSetSpec instance) {
    this(fluent, instance, false);
  }
  public DaemonSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.DaemonSetSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMinReadySeconds(instance.getMinReadySeconds()); 
    fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withTemplate(instance.getTemplate()); 
    fluent.withTemplateGeneration(instance.getTemplateGeneration()); 
    fluent.withUpdateStrategy(instance.getUpdateStrategy()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DaemonSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetSpec instance) {
    this(instance,false);
  }
  public DaemonSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMinReadySeconds(instance.getMinReadySeconds()); 
    this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
    this.withSelector(instance.getSelector()); 
    this.withTemplate(instance.getTemplate()); 
    this.withTemplateGeneration(instance.getTemplateGeneration()); 
    this.withUpdateStrategy(instance.getUpdateStrategy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpec build() {
    DaemonSetSpec buildable = new DaemonSetSpec(fluent.getMinReadySeconds(),fluent.getRevisionHistoryLimit(),fluent.getSelector(),fluent.getTemplate(),fluent.getTemplateGeneration(),fluent.getUpdateStrategy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}