package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DaemonSetListBuilder extends DaemonSetListFluentImpl<DaemonSetListBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.DaemonSetList,io.fabric8.kubernetes.api.model.extensions.DaemonSetListBuilder>{
  public DaemonSetListBuilder() {
    this(false);
  }
  public DaemonSetListBuilder(Boolean validationEnabled) {
    this(new DaemonSetList(), validationEnabled);
  }
  public DaemonSetListBuilder(DaemonSetListFluent<?> fluent) {
    this(fluent, false);
  }
  public DaemonSetListBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DaemonSetList(), validationEnabled);
  }
  public DaemonSetListBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetListFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.DaemonSetList instance) {
    this(fluent, instance, false);
  }
  public DaemonSetListBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetListFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.DaemonSetList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DaemonSetListBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetList instance) {
    this(instance,false);
  }
  public DaemonSetListBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.DaemonSetListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.DaemonSetList build() {
    DaemonSetList buildable = new DaemonSetList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}