package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DaemonSetBuilder extends DaemonSetFluentImpl<DaemonSetBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.DaemonSet,io.fabric8.kubernetes.api.model.extensions.DaemonSetBuilder>{
  public DaemonSetBuilder() {
    this(false);
  }
  public DaemonSetBuilder(Boolean validationEnabled) {
    this(new DaemonSet(), validationEnabled);
  }
  public DaemonSetBuilder(DaemonSetFluent<?> fluent) {
    this(fluent, false);
  }
  public DaemonSetBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DaemonSet(), validationEnabled);
  }
  public DaemonSetBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.DaemonSet instance) {
    this(fluent, instance, false);
  }
  public DaemonSetBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.DaemonSet instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DaemonSetBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSet instance) {
    this(instance,false);
  }
  public DaemonSetBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSet instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.DaemonSetFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.DaemonSet build() {
    DaemonSet buildable = new DaemonSet(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}