package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class DeploymentListBuilder extends io.fabric8.kubernetes.api.model.extensions.DeploymentListFluentImpl<io.fabric8.kubernetes.api.model.extensions.DeploymentListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.DeploymentList,io.fabric8.kubernetes.api.model.extensions.DeploymentListBuilder>{
  public DeploymentListBuilder() {
    this(false);
  }
  public DeploymentListBuilder(java.lang.Boolean validationEnabled) {
    this(new DeploymentList(), validationEnabled);
  }
  public DeploymentListBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentListFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentListBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DeploymentList(), validationEnabled);
  }
  public DeploymentListBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentListFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.DeploymentList instance) {
    this(fluent, instance, false);
  }
  public DeploymentListBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentListFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.DeploymentList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public DeploymentListBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentList instance) {
    this(instance,false);
  }
  public DeploymentListBuilder(io.fabric8.kubernetes.api.model.extensions.DeploymentList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.DeploymentListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.DeploymentList build() {
    DeploymentList buildable = new DeploymentList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DeploymentListBuilder that = (DeploymentListBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}