package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class NetworkPolicyBuilder extends io.fabric8.kubernetes.api.model.extensions.NetworkPolicyFluentImpl<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.NetworkPolicy,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyBuilder>{
  public NetworkPolicyBuilder() {
    this(false);
  }
  public NetworkPolicyBuilder(java.lang.Boolean validationEnabled) {
    this(new NetworkPolicy(), validationEnabled);
  }
  public NetworkPolicyBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkPolicyBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NetworkPolicy(), validationEnabled);
  }
  public NetworkPolicyBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.NetworkPolicy instance) {
    this(fluent, instance, false);
  }
  public NetworkPolicyBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.NetworkPolicy instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    this.validationEnabled = validationEnabled; 
  }
  public NetworkPolicyBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicy instance) {
    this(instance,false);
  }
  public NetworkPolicyBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicy instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.NetworkPolicyFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.NetworkPolicy build() {
    NetworkPolicy buildable = new NetworkPolicy(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkPolicyBuilder that = (NetworkPolicyBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}