package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
public class IngressSpecFluentImpl<A extends io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent<A>{
  public IngressSpecFluentImpl() {
  }
  public IngressSpecFluentImpl(io.fabric8.kubernetes.api.model.extensions.IngressSpec instance) {
    this.withBackend(instance.getBackend()); 
    this.withIngressClassName(instance.getIngressClassName()); 
    this.withRules(instance.getRules()); 
    this.withTls(instance.getTls()); 
  }
  private io.fabric8.kubernetes.api.model.extensions.IngressBackendBuilder backend;
  private java.lang.String ingressClassName;
  private java.util.List<io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder> rules =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder>();
  private java.util.List<io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder> tls =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder>();
  
  /**
   * This method has been deprecated, please use method buildBackend instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.extensions.IngressBackend getBackend() {
    return this.backend!=null?this.backend.build():null;
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressBackend buildBackend() {
    return this.backend!=null?this.backend.build():null;
  }
  public A withBackend(io.fabric8.kubernetes.api.model.extensions.IngressBackend backend) {
    _visitables.get("backend").remove(this.backend);
    if (backend!=null){ this.backend= new io.fabric8.kubernetes.api.model.extensions.IngressBackendBuilder(backend); _visitables.get("backend").add(this.backend);} return (A) this;
  }
  public java.lang.Boolean hasBackend() {
    return this.backend != null;
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.BackendNested<A> withNewBackend() {
    return new io.fabric8.kubernetes.api.model.extensions.IngressSpecFluentImpl.BackendNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.BackendNested<A> withNewBackendLike(io.fabric8.kubernetes.api.model.extensions.IngressBackend item) {
    return new io.fabric8.kubernetes.api.model.extensions.IngressSpecFluentImpl.BackendNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.BackendNested<A> editBackend() {
    return withNewBackendLike(getBackend());
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.BackendNested<A> editOrNewBackend() {
    return withNewBackendLike(getBackend() != null ? getBackend(): new io.fabric8.kubernetes.api.model.extensions.IngressBackendBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.BackendNested<A> editOrNewBackendLike(io.fabric8.kubernetes.api.model.extensions.IngressBackend item) {
    return withNewBackendLike(getBackend() != null ? getBackend(): item);
  }
  public java.lang.String getIngressClassName() {
    return this.ingressClassName;
  }
  public A withIngressClassName(java.lang.String ingressClassName) {
    this.ingressClassName=ingressClassName; return (A) this;
  }
  public java.lang.Boolean hasIngressClassName() {
    return this.ingressClassName != null;
  }
  
  /**
   * Method is deprecated. use withIngressClassName instead.
   */
  @java.lang.Deprecated
  public A withNewIngressClassName(java.lang.String arg0) {
    return (A)withIngressClassName(new String(arg0));
  }
  public A addToRules(java.lang.Integer index,io.fabric8.kubernetes.api.model.extensions.IngressRule item) {
    if (this.rules == null) {this.rules = new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder>();}
    io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder builder = new io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder(item);_visitables.get("rules").add(index >= 0 ? index : _visitables.get("rules").size(), builder);this.rules.add(index >= 0 ? index : rules.size(), builder); return (A)this;
  }
  public A setToRules(java.lang.Integer index,io.fabric8.kubernetes.api.model.extensions.IngressRule item) {
    if (this.rules == null) {this.rules = new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder>();}
    io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder builder = new io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder(item);
    if (index < 0 || index >= _visitables.get("rules").size()) { _visitables.get("rules").add(builder); } else { _visitables.get("rules").set(index, builder);}
    if (index < 0 || index >= rules.size()) { rules.add(builder); } else { rules.set(index, builder);}
     return (A)this;
  }
  public A addToRules(io.fabric8.kubernetes.api.model.extensions.IngressRule... items) {
    if (this.rules == null) {this.rules = new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder>();}
    for (io.fabric8.kubernetes.api.model.extensions.IngressRule item : items) {io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder builder = new io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A addAllToRules(java.util.Collection<io.fabric8.kubernetes.api.model.extensions.IngressRule> items) {
    if (this.rules == null) {this.rules = new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder>();}
    for (io.fabric8.kubernetes.api.model.extensions.IngressRule item : items) {io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder builder = new io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A removeFromRules(io.fabric8.kubernetes.api.model.extensions.IngressRule... items) {
    for (io.fabric8.kubernetes.api.model.extensions.IngressRule item : items) {io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder builder = new io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
  }
  public A removeAllFromRules(java.util.Collection<io.fabric8.kubernetes.api.model.extensions.IngressRule> items) {
    for (io.fabric8.kubernetes.api.model.extensions.IngressRule item : items) {io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder builder = new io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRules(java.util.function.Predicate<io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder> predicate) {
    if (rules == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder> each = rules.iterator();
    final List visitables = _visitables.get("rules");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRules instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.extensions.IngressRule> getRules() {
    return build(rules);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.extensions.IngressRule> buildRules() {
    return build(rules);
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressRule buildRule(java.lang.Integer index) {
    return this.rules.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressRule buildFirstRule() {
    return this.rules.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressRule buildLastRule() {
    return this.rules.get(rules.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressRule buildMatchingRule(java.util.function.Predicate<io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder item: rules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingRule(java.util.function.Predicate<io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder item: rules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRules(java.util.List<io.fabric8.kubernetes.api.model.extensions.IngressRule> rules) {
    if (this.rules != null) { _visitables.get("rules").removeAll(this.rules);}
    if (rules != null) {this.rules = new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder>(); for (io.fabric8.kubernetes.api.model.extensions.IngressRule item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
  }
  public A withRules(io.fabric8.kubernetes.api.model.extensions.IngressRule... rules) {
    if (this.rules != null) {this.rules.clear();}
    if (rules != null) {for (io.fabric8.kubernetes.api.model.extensions.IngressRule item :rules){ this.addToRules(item);}} return (A) this;
  }
  public java.lang.Boolean hasRules() {
    return rules != null && !rules.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.RulesNested<A> addNewRule() {
    return new io.fabric8.kubernetes.api.model.extensions.IngressSpecFluentImpl.RulesNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.RulesNested<A> addNewRuleLike(io.fabric8.kubernetes.api.model.extensions.IngressRule item) {
    return new io.fabric8.kubernetes.api.model.extensions.IngressSpecFluentImpl.RulesNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.RulesNested<A> setNewRuleLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.extensions.IngressRule item) {
    return new io.fabric8.kubernetes.api.model.extensions.IngressSpecFluentImpl.RulesNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.RulesNested<A> editRule(java.lang.Integer index) {
    if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
    return setNewRuleLike(index, buildRule(index));
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.RulesNested<A> editFirstRule() {
    if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
    return setNewRuleLike(0, buildRule(0));
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.RulesNested<A> editLastRule() {
    int index = rules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
    return setNewRuleLike(index, buildRule(index));
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.RulesNested<A> editMatchingRule(java.util.function.Predicate<io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<rules.size();i++) { 
    if (predicate.test(rules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
    return setNewRuleLike(index, buildRule(index));
  }
  public A addToTls(java.lang.Integer index,io.fabric8.kubernetes.api.model.extensions.IngressTLS item) {
    if (this.tls == null) {this.tls = new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder>();}
    io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder builder = new io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder(item);_visitables.get("tls").add(index >= 0 ? index : _visitables.get("tls").size(), builder);this.tls.add(index >= 0 ? index : tls.size(), builder); return (A)this;
  }
  public A setToTls(java.lang.Integer index,io.fabric8.kubernetes.api.model.extensions.IngressTLS item) {
    if (this.tls == null) {this.tls = new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder>();}
    io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder builder = new io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder(item);
    if (index < 0 || index >= _visitables.get("tls").size()) { _visitables.get("tls").add(builder); } else { _visitables.get("tls").set(index, builder);}
    if (index < 0 || index >= tls.size()) { tls.add(builder); } else { tls.set(index, builder);}
     return (A)this;
  }
  public A addToTls(io.fabric8.kubernetes.api.model.extensions.IngressTLS... items) {
    if (this.tls == null) {this.tls = new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder>();}
    for (io.fabric8.kubernetes.api.model.extensions.IngressTLS item : items) {io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder builder = new io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder(item);_visitables.get("tls").add(builder);this.tls.add(builder);} return (A)this;
  }
  public A addAllToTls(java.util.Collection<io.fabric8.kubernetes.api.model.extensions.IngressTLS> items) {
    if (this.tls == null) {this.tls = new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder>();}
    for (io.fabric8.kubernetes.api.model.extensions.IngressTLS item : items) {io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder builder = new io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder(item);_visitables.get("tls").add(builder);this.tls.add(builder);} return (A)this;
  }
  public A removeFromTls(io.fabric8.kubernetes.api.model.extensions.IngressTLS... items) {
    for (io.fabric8.kubernetes.api.model.extensions.IngressTLS item : items) {io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder builder = new io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder(item);_visitables.get("tls").remove(builder);if (this.tls != null) {this.tls.remove(builder);}} return (A)this;
  }
  public A removeAllFromTls(java.util.Collection<io.fabric8.kubernetes.api.model.extensions.IngressTLS> items) {
    for (io.fabric8.kubernetes.api.model.extensions.IngressTLS item : items) {io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder builder = new io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder(item);_visitables.get("tls").remove(builder);if (this.tls != null) {this.tls.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTls(java.util.function.Predicate<io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder> predicate) {
    if (tls == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder> each = tls.iterator();
    final List visitables = _visitables.get("tls");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTls instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.extensions.IngressTLS> getTls() {
    return build(tls);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.extensions.IngressTLS> buildTls() {
    return build(tls);
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressTLS buildTl(java.lang.Integer index) {
    return this.tls.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressTLS buildFirstTl() {
    return this.tls.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressTLS buildLastTl() {
    return this.tls.get(tls.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressTLS buildMatchingTl(java.util.function.Predicate<io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder item: tls) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingTl(java.util.function.Predicate<io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder item: tls) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTls(java.util.List<io.fabric8.kubernetes.api.model.extensions.IngressTLS> tls) {
    if (this.tls != null) { _visitables.get("tls").removeAll(this.tls);}
    if (tls != null) {this.tls = new java.util.ArrayList<io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder>(); for (io.fabric8.kubernetes.api.model.extensions.IngressTLS item : tls){this.addToTls(item);}} else { this.tls = null;} return (A) this;
  }
  public A withTls(io.fabric8.kubernetes.api.model.extensions.IngressTLS... tls) {
    if (this.tls != null) {this.tls.clear();}
    if (tls != null) {for (io.fabric8.kubernetes.api.model.extensions.IngressTLS item :tls){ this.addToTls(item);}} return (A) this;
  }
  public java.lang.Boolean hasTls() {
    return tls != null && !tls.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.TlsNested<A> addNewTl() {
    return new io.fabric8.kubernetes.api.model.extensions.IngressSpecFluentImpl.TlsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.TlsNested<A> addNewTlLike(io.fabric8.kubernetes.api.model.extensions.IngressTLS item) {
    return new io.fabric8.kubernetes.api.model.extensions.IngressSpecFluentImpl.TlsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.TlsNested<A> setNewTlLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.extensions.IngressTLS item) {
    return new io.fabric8.kubernetes.api.model.extensions.IngressSpecFluentImpl.TlsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.TlsNested<A> editTl(java.lang.Integer index) {
    if (tls.size() <= index) throw new RuntimeException("Can't edit tls. Index exceeds size.");
    return setNewTlLike(index, buildTl(index));
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.TlsNested<A> editFirstTl() {
    if (tls.size() == 0) throw new RuntimeException("Can't edit first tls. The list is empty.");
    return setNewTlLike(0, buildTl(0));
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.TlsNested<A> editLastTl() {
    int index = tls.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last tls. The list is empty.");
    return setNewTlLike(index, buildTl(index));
  }
  public io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.TlsNested<A> editMatchingTl(java.util.function.Predicate<io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder> predicate) {
    int index = -1;
    for (int i=0;i<tls.size();i++) { 
    if (predicate.test(tls.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching tls. No match found.");
    return setNewTlLike(index, buildTl(index));
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IngressSpecFluentImpl that = (IngressSpecFluentImpl) o;
    if (backend != null ? !backend.equals(that.backend) :that.backend != null) return false;
    if (ingressClassName != null ? !ingressClassName.equals(that.ingressClassName) :that.ingressClassName != null) return false;
    if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
    if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(backend,  ingressClassName,  rules,  tls,  super.hashCode());
  }
  public class BackendNestedImpl<N> extends io.fabric8.kubernetes.api.model.extensions.IngressBackendFluentImpl<io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.BackendNested<N>> implements io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.BackendNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BackendNestedImpl(io.fabric8.kubernetes.api.model.extensions.IngressBackend item) {
      this.builder = new io.fabric8.kubernetes.api.model.extensions.IngressBackendBuilder(this, item);
    }
    BackendNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.extensions.IngressBackendBuilder(this);
    }
    io.fabric8.kubernetes.api.model.extensions.IngressBackendBuilder builder;
    public N and() {
      return (N) IngressSpecFluentImpl.this.withBackend(builder.build());
    }
    public N endBackend() {
      return and();
    }
    
  }
  public class RulesNestedImpl<N> extends io.fabric8.kubernetes.api.model.extensions.IngressRuleFluentImpl<io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.RulesNested<N>> implements io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.RulesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RulesNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.extensions.IngressRule item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder(this, item);
    }
    RulesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder(this);
    }
    io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) IngressSpecFluentImpl.this.setToRules(index,builder.build());
    }
    public N endRule() {
      return and();
    }
    
  }
  public class TlsNestedImpl<N> extends io.fabric8.kubernetes.api.model.extensions.IngressTLSFluentImpl<io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.TlsNested<N>> implements io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent.TlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TlsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.extensions.IngressTLS item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder(this, item);
    }
    TlsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder(this);
    }
    io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) IngressSpecFluentImpl.this.setToTls(index,builder.build());
    }
    public N endTl() {
      return and();
    }
    
  }
  
}