package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class DaemonSetStatusBuilder extends io.fabric8.kubernetes.api.model.extensions.DaemonSetStatusFluentImpl<io.fabric8.kubernetes.api.model.extensions.DaemonSetStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.DaemonSetStatus,io.fabric8.kubernetes.api.model.extensions.DaemonSetStatusBuilder>{
  public DaemonSetStatusBuilder() {
    this(false);
  }
  public DaemonSetStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new DaemonSetStatus(), validationEnabled);
  }
  public DaemonSetStatusBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public DaemonSetStatusBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DaemonSetStatus(), validationEnabled);
  }
  public DaemonSetStatusBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.DaemonSetStatus instance) {
    this(fluent, instance, false);
  }
  public DaemonSetStatusBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.DaemonSetStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCollisionCount(instance.getCollisionCount()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withCurrentNumberScheduled(instance.getCurrentNumberScheduled()); 
    fluent.withDesiredNumberScheduled(instance.getDesiredNumberScheduled()); 
    fluent.withNumberAvailable(instance.getNumberAvailable()); 
    fluent.withNumberMisscheduled(instance.getNumberMisscheduled()); 
    fluent.withNumberReady(instance.getNumberReady()); 
    fluent.withNumberUnavailable(instance.getNumberUnavailable()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withUpdatedNumberScheduled(instance.getUpdatedNumberScheduled()); 
    this.validationEnabled = validationEnabled; 
  }
  public DaemonSetStatusBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetStatus instance) {
    this(instance,false);
  }
  public DaemonSetStatusBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCollisionCount(instance.getCollisionCount()); 
    this.withConditions(instance.getConditions()); 
    this.withCurrentNumberScheduled(instance.getCurrentNumberScheduled()); 
    this.withDesiredNumberScheduled(instance.getDesiredNumberScheduled()); 
    this.withNumberAvailable(instance.getNumberAvailable()); 
    this.withNumberMisscheduled(instance.getNumberMisscheduled()); 
    this.withNumberReady(instance.getNumberReady()); 
    this.withNumberUnavailable(instance.getNumberUnavailable()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withUpdatedNumberScheduled(instance.getUpdatedNumberScheduled()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.DaemonSetStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.DaemonSetStatus build() {
    DaemonSetStatus buildable = new DaemonSetStatus(fluent.getCollisionCount(),fluent.getConditions(),fluent.getCurrentNumberScheduled(),fluent.getDesiredNumberScheduled(),fluent.getNumberAvailable(),fluent.getNumberMisscheduled(),fluent.getNumberReady(),fluent.getNumberUnavailable(),fluent.getObservedGeneration(),fluent.getUpdatedNumberScheduled());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DaemonSetStatusBuilder that = (DaemonSetStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}