package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class DaemonSetSpecBuilder extends io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluentImpl<io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.DaemonSetSpec,io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecBuilder>{
  public DaemonSetSpecBuilder() {
    this(false);
  }
  public DaemonSetSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new DaemonSetSpec(), validationEnabled);
  }
  public DaemonSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DaemonSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DaemonSetSpec(), validationEnabled);
  }
  public DaemonSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.DaemonSetSpec instance) {
    this(fluent, instance, false);
  }
  public DaemonSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.DaemonSetSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMinReadySeconds(instance.getMinReadySeconds()); 
    fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withTemplate(instance.getTemplate()); 
    fluent.withTemplateGeneration(instance.getTemplateGeneration()); 
    fluent.withUpdateStrategy(instance.getUpdateStrategy()); 
    this.validationEnabled = validationEnabled; 
  }
  public DaemonSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetSpec instance) {
    this(instance,false);
  }
  public DaemonSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMinReadySeconds(instance.getMinReadySeconds()); 
    this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
    this.withSelector(instance.getSelector()); 
    this.withTemplate(instance.getTemplate()); 
    this.withTemplateGeneration(instance.getTemplateGeneration()); 
    this.withUpdateStrategy(instance.getUpdateStrategy()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpec build() {
    DaemonSetSpec buildable = new DaemonSetSpec(fluent.getMinReadySeconds(),fluent.getRevisionHistoryLimit(),fluent.getSelector(),fluent.getTemplate(),fluent.getTemplateGeneration(),fluent.getUpdateStrategy());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DaemonSetSpecBuilder that = (DaemonSetSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}