package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class DaemonSetListBuilder extends io.fabric8.kubernetes.api.model.extensions.DaemonSetListFluentImpl<io.fabric8.kubernetes.api.model.extensions.DaemonSetListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.DaemonSetList,io.fabric8.kubernetes.api.model.extensions.DaemonSetListBuilder>{
  public DaemonSetListBuilder() {
    this(false);
  }
  public DaemonSetListBuilder(java.lang.Boolean validationEnabled) {
    this(new DaemonSetList(), validationEnabled);
  }
  public DaemonSetListBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetListFluent<?> fluent) {
    this(fluent, false);
  }
  public DaemonSetListBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DaemonSetList(), validationEnabled);
  }
  public DaemonSetListBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetListFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.DaemonSetList instance) {
    this(fluent, instance, false);
  }
  public DaemonSetListBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetListFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.DaemonSetList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public DaemonSetListBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetList instance) {
    this(instance,false);
  }
  public DaemonSetListBuilder(io.fabric8.kubernetes.api.model.extensions.DaemonSetList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.DaemonSetListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.DaemonSetList build() {
    DaemonSetList buildable = new DaemonSetList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DaemonSetListBuilder that = (DaemonSetListBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}