package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkPolicyEgressRuleBuilder extends io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleFluentImpl<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder> {

    io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public NetworkPolicyEgressRuleBuilder() {
        this(true);
    }

    public NetworkPolicyEgressRuleBuilder(java.lang.Boolean validationEnabled) {
        this(new NetworkPolicyEgressRule(), validationEnabled);
    }

    public NetworkPolicyEgressRuleBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleFluent<?> fluent) {
        this(fluent, true);
    }

    public NetworkPolicyEgressRuleBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new NetworkPolicyEgressRule(), validationEnabled);
    }

    public NetworkPolicyEgressRuleBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule instance) {
        this(fluent, instance, true);
    }

    public NetworkPolicyEgressRuleBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withPorts(instance.getPorts()); 
        fluent.withTo(instance.getTo()); 
        this.validationEnabled = validationEnabled; 
    }

    public NetworkPolicyEgressRuleBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule instance) {
        this(instance,true);
    }

    public NetworkPolicyEgressRuleBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withPorts(instance.getPorts()); 
        this.withTo(instance.getTo()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule build() {
        NetworkPolicyEgressRule buildable = new NetworkPolicyEgressRule(fluent.getPorts(),fluent.getTo());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NetworkPolicyEgressRuleBuilder that = (NetworkPolicyEgressRuleBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
