package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IPBlockBuilder extends io.fabric8.kubernetes.api.model.extensions.IPBlockFluentImpl<io.fabric8.kubernetes.api.model.extensions.IPBlockBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.IPBlock,io.fabric8.kubernetes.api.model.extensions.IPBlockBuilder> {

    io.fabric8.kubernetes.api.model.extensions.IPBlockFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public IPBlockBuilder() {
        this(true);
    }

    public IPBlockBuilder(java.lang.Boolean validationEnabled) {
        this(new IPBlock(), validationEnabled);
    }

    public IPBlockBuilder(io.fabric8.kubernetes.api.model.extensions.IPBlockFluent<?> fluent) {
        this(fluent, true);
    }

    public IPBlockBuilder(io.fabric8.kubernetes.api.model.extensions.IPBlockFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new IPBlock(), validationEnabled);
    }

    public IPBlockBuilder(io.fabric8.kubernetes.api.model.extensions.IPBlockFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.IPBlock instance) {
        this(fluent, instance, true);
    }

    public IPBlockBuilder(io.fabric8.kubernetes.api.model.extensions.IPBlockFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.IPBlock instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCidr(instance.getCidr()); 
        fluent.withExcept(instance.getExcept()); 
        this.validationEnabled = validationEnabled; 
    }

    public IPBlockBuilder(io.fabric8.kubernetes.api.model.extensions.IPBlock instance) {
        this(instance,true);
    }

    public IPBlockBuilder(io.fabric8.kubernetes.api.model.extensions.IPBlock instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withCidr(instance.getCidr()); 
        this.withExcept(instance.getExcept()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.extensions.IPBlock build() {
        IPBlock buildable = new IPBlock(fluent.getCidr(),fluent.getExcept());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IPBlockBuilder that = (IPBlockBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
