package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.TypedLocalObjectReference;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import java.lang.Boolean;

public class IngressBackendFluentImpl<A extends io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent<A> {

    private io.fabric8.kubernetes.api.model.TypedLocalObjectReference resource;
    private java.lang.String serviceName;
    private io.fabric8.kubernetes.api.model.IntOrStringBuilder servicePort;

    public IngressBackendFluentImpl() {
    }

    public IngressBackendFluentImpl(io.fabric8.kubernetes.api.model.extensions.IngressBackend instance) {
        this.withResource(instance.getResource()); 
        this.withServiceName(instance.getServiceName()); 
        this.withServicePort(instance.getServicePort()); 
    }

    public io.fabric8.kubernetes.api.model.TypedLocalObjectReference getResource() {
        return this.resource;
    }

    public A withResource(io.fabric8.kubernetes.api.model.TypedLocalObjectReference resource) {
        this.resource=resource; return (A) this;
    }

    public java.lang.Boolean hasResource() {
        return this.resource != null;
    }

    public A withNewResource(java.lang.String apiGroup,java.lang.String kind,java.lang.String name) {
        return (A)withResource(new TypedLocalObjectReference(apiGroup, kind, name));
    }

    public java.lang.String getServiceName() {
        return this.serviceName;
    }

    public A withServiceName(java.lang.String serviceName) {
        this.serviceName=serviceName; return (A) this;
    }

    public java.lang.Boolean hasServiceName() {
        return this.serviceName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withServiceName instead.
     */
        public A withNewServiceName(java.lang.String arg0) {
        return (A)withServiceName(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildServicePort instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.IntOrString getServicePort() {
        return this.servicePort!=null?this.servicePort.build():null;
    }

    public io.fabric8.kubernetes.api.model.IntOrString buildServicePort() {
        return this.servicePort!=null?this.servicePort.build():null;
    }

    public A withServicePort(io.fabric8.kubernetes.api.model.IntOrString servicePort) {
        _visitables.get("servicePort").remove(this.servicePort);
        if (servicePort!=null){ this.servicePort= new io.fabric8.kubernetes.api.model.IntOrStringBuilder(servicePort); _visitables.get("servicePort").add(this.servicePort);} return (A) this;
    }

    public java.lang.Boolean hasServicePort() {
        return this.servicePort != null;
    }

    public A withNewServicePort(java.lang.Integer intVal) {
        return (A)withServicePort(new IntOrString(intVal));
    }

    public A withNewServicePort(java.lang.String strVal) {
        return (A)withServicePort(new IntOrString(strVal));
    }

    public io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent.ServicePortNested<A> withNewServicePort() {
        return new io.fabric8.kubernetes.api.model.extensions.IngressBackendFluentImpl.ServicePortNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent.ServicePortNested<A> withNewServicePortLike(io.fabric8.kubernetes.api.model.IntOrString item) {
        return new io.fabric8.kubernetes.api.model.extensions.IngressBackendFluentImpl.ServicePortNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent.ServicePortNested<A> editServicePort() {
        return withNewServicePortLike(getServicePort());
    }

    public io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent.ServicePortNested<A> editOrNewServicePort() {
        return withNewServicePortLike(getServicePort() != null ? getServicePort(): new io.fabric8.kubernetes.api.model.IntOrStringBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent.ServicePortNested<A> editOrNewServicePortLike(io.fabric8.kubernetes.api.model.IntOrString item) {
        return withNewServicePortLike(getServicePort() != null ? getServicePort(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IngressBackendFluentImpl that = (IngressBackendFluentImpl) o;
        if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
        if (serviceName != null ? !serviceName.equals(that.serviceName) :that.serviceName != null) return false;
        if (servicePort != null ? !servicePort.equals(that.servicePort) :that.servicePort != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(resource,  serviceName,  servicePort,  super.hashCode());
    }

    public class ServicePortNestedImpl<N> extends io.fabric8.kubernetes.api.model.IntOrStringFluentImpl<io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent.ServicePortNested<N>> implements io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent.ServicePortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.IntOrStringBuilder builder;

            ServicePortNestedImpl(io.fabric8.kubernetes.api.model.IntOrString item) {
                this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this, item);
                        
            }

            ServicePortNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this);
                        
            }

            public N and() {
                return (N) IngressBackendFluentImpl.this.withServicePort(builder.build());
            }

            public N endServicePort() {
                return and();
            }
    }


}
