package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RollingUpdateDeploymentBuilder extends io.fabric8.kubernetes.api.model.extensions.RollingUpdateDeploymentFluentImpl<io.fabric8.kubernetes.api.model.extensions.RollingUpdateDeploymentBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.RollingUpdateDeployment,io.fabric8.kubernetes.api.model.extensions.RollingUpdateDeploymentBuilder> {

    io.fabric8.kubernetes.api.model.extensions.RollingUpdateDeploymentFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public RollingUpdateDeploymentBuilder() {
        this(true);
    }

    public RollingUpdateDeploymentBuilder(java.lang.Boolean validationEnabled) {
        this(new RollingUpdateDeployment(), validationEnabled);
    }

    public RollingUpdateDeploymentBuilder(io.fabric8.kubernetes.api.model.extensions.RollingUpdateDeploymentFluent<?> fluent) {
        this(fluent, true);
    }

    public RollingUpdateDeploymentBuilder(io.fabric8.kubernetes.api.model.extensions.RollingUpdateDeploymentFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new RollingUpdateDeployment(), validationEnabled);
    }

    public RollingUpdateDeploymentBuilder(io.fabric8.kubernetes.api.model.extensions.RollingUpdateDeploymentFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.RollingUpdateDeployment instance) {
        this(fluent, instance, true);
    }

    public RollingUpdateDeploymentBuilder(io.fabric8.kubernetes.api.model.extensions.RollingUpdateDeploymentFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.RollingUpdateDeployment instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withMaxSurge(instance.getMaxSurge()); 
        fluent.withMaxUnavailable(instance.getMaxUnavailable()); 
        this.validationEnabled = validationEnabled; 
    }

    public RollingUpdateDeploymentBuilder(io.fabric8.kubernetes.api.model.extensions.RollingUpdateDeployment instance) {
        this(instance,true);
    }

    public RollingUpdateDeploymentBuilder(io.fabric8.kubernetes.api.model.extensions.RollingUpdateDeployment instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withMaxSurge(instance.getMaxSurge()); 
        this.withMaxUnavailable(instance.getMaxUnavailable()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.extensions.RollingUpdateDeployment build() {
        RollingUpdateDeployment buildable = new RollingUpdateDeployment(fluent.getMaxSurge(),fluent.getMaxUnavailable());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RollingUpdateDeploymentBuilder that = (RollingUpdateDeploymentBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
