package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressStatusBuilder extends io.fabric8.kubernetes.api.model.extensions.IngressStatusFluentImpl<io.fabric8.kubernetes.api.model.extensions.IngressStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.IngressStatus,io.fabric8.kubernetes.api.model.extensions.IngressStatusBuilder> {

    io.fabric8.kubernetes.api.model.extensions.IngressStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public IngressStatusBuilder() {
        this(true);
    }

    public IngressStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new IngressStatus(), validationEnabled);
    }

    public IngressStatusBuilder(io.fabric8.kubernetes.api.model.extensions.IngressStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public IngressStatusBuilder(io.fabric8.kubernetes.api.model.extensions.IngressStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new IngressStatus(), validationEnabled);
    }

    public IngressStatusBuilder(io.fabric8.kubernetes.api.model.extensions.IngressStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.IngressStatus instance) {
        this(fluent, instance, true);
    }

    public IngressStatusBuilder(io.fabric8.kubernetes.api.model.extensions.IngressStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.IngressStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLoadBalancer(instance.getLoadBalancer()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressStatusBuilder(io.fabric8.kubernetes.api.model.extensions.IngressStatus instance) {
        this(instance,true);
    }

    public IngressStatusBuilder(io.fabric8.kubernetes.api.model.extensions.IngressStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withLoadBalancer(instance.getLoadBalancer()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.extensions.IngressStatus build() {
        IngressStatus buildable = new IngressStatus(fluent.getLoadBalancer());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressStatusBuilder that = (IngressStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
