package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HTTPIngressPathBuilder extends io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluentImpl<io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath,io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathBuilder> {

    io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public HTTPIngressPathBuilder() {
        this(true);
    }

    public HTTPIngressPathBuilder(java.lang.Boolean validationEnabled) {
        this(new HTTPIngressPath(), validationEnabled);
    }

    public HTTPIngressPathBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent<?> fluent) {
        this(fluent, true);
    }

    public HTTPIngressPathBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new HTTPIngressPath(), validationEnabled);
    }

    public HTTPIngressPathBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath instance) {
        this(fluent, instance, true);
    }

    public HTTPIngressPathBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBackend(instance.getBackend()); 
        fluent.withPath(instance.getPath()); 
        fluent.withPathType(instance.getPathType()); 
        this.validationEnabled = validationEnabled; 
    }

    public HTTPIngressPathBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath instance) {
        this(instance,true);
    }

    public HTTPIngressPathBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withBackend(instance.getBackend()); 
        this.withPath(instance.getPath()); 
        this.withPathType(instance.getPathType()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath build() {
        HTTPIngressPath buildable = new HTTPIngressPath(fluent.getBackend(),fluent.getPath(),fluent.getPathType());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        HTTPIngressPathBuilder that = (HTTPIngressPathBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
