package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkPolicyListBuilder extends io.fabric8.kubernetes.api.model.extensions.NetworkPolicyListFluentImpl<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyList,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyListBuilder> {

    io.fabric8.kubernetes.api.model.extensions.NetworkPolicyListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public NetworkPolicyListBuilder() {
        this(true);
    }

    public NetworkPolicyListBuilder(java.lang.Boolean validationEnabled) {
        this(new NetworkPolicyList(), validationEnabled);
    }

    public NetworkPolicyListBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyListFluent<?> fluent) {
        this(fluent, true);
    }

    public NetworkPolicyListBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new NetworkPolicyList(), validationEnabled);
    }

    public NetworkPolicyListBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyListFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyList instance) {
        this(fluent, instance, true);
    }

    public NetworkPolicyListBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyListFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public NetworkPolicyListBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyList instance) {
        this(instance,true);
    }

    public NetworkPolicyListBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.extensions.NetworkPolicyList build() {
        NetworkPolicyList buildable = new NetworkPolicyList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NetworkPolicyListBuilder that = (NetworkPolicyListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
