package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RollbackConfigBuilder extends RollbackConfigFluentImpl<RollbackConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<RollbackConfig,RollbackConfigBuilder> {

    RollbackConfigFluent<?> fluent;
    Boolean validationEnabled;

    public RollbackConfigBuilder() {
        this(true);
    }

    public RollbackConfigBuilder(Boolean validationEnabled) {
        this(new RollbackConfig(), validationEnabled);
    }

    public RollbackConfigBuilder(RollbackConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public RollbackConfigBuilder(RollbackConfigFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new RollbackConfig(), validationEnabled);
    }

    public RollbackConfigBuilder(RollbackConfigFluent<?> fluent,RollbackConfig instance) {
        this(fluent, instance, true);
    }

    public RollbackConfigBuilder(RollbackConfigFluent<?> fluent,RollbackConfig instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withRevision(instance.getRevision()); 
        this.validationEnabled = validationEnabled; 
    }

    public RollbackConfigBuilder(RollbackConfig instance) {
        this(instance,true);
    }

    public RollbackConfigBuilder(RollbackConfig instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withRevision(instance.getRevision()); 
        this.validationEnabled = validationEnabled; 
    }

    public RollbackConfig build() {
        RollbackConfig buildable = new RollbackConfig(fluent.getRevision());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RollbackConfigBuilder that = (RollbackConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
