package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

public interface DaemonSetSpecFluent<A extends DaemonSetSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Integer getMinReadySeconds();
    public A withMinReadySeconds(Integer minReadySeconds);
    public Boolean hasMinReadySeconds();
    public A withNewMinReadySeconds(int arg0);
    public Integer getRevisionHistoryLimit();
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit);
    public Boolean hasRevisionHistoryLimit();
    public A withNewRevisionHistoryLimit(int arg0);
    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getSelector();
    public LabelSelector buildSelector();
    public A withSelector(LabelSelector selector);
    public Boolean hasSelector();
    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.SelectorNested<A> withNewSelector();
    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.SelectorNested<A> editSelector();
    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.SelectorNested<A> editOrNewSelector();
    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item);
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplateSpec getTemplate();
    public PodTemplateSpec buildTemplate();
    public A withTemplate(PodTemplateSpec template);
    public Boolean hasTemplate();
    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.TemplateNested<A> withNewTemplate();
    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.TemplateNested<A> editTemplate();
    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.TemplateNested<A> editOrNewTemplate();
    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item);
    public Long getTemplateGeneration();
    public A withTemplateGeneration(Long templateGeneration);
    public Boolean hasTemplateGeneration();
    public A withNewTemplateGeneration(long arg1);
    
/**
 * This method has been deprecated, please use method buildUpdateStrategy instead.
 * @return The buildable object.
 */
@Deprecated public DaemonSetUpdateStrategy getUpdateStrategy();
    public DaemonSetUpdateStrategy buildUpdateStrategy();
    public A withUpdateStrategy(DaemonSetUpdateStrategy updateStrategy);
    public Boolean hasUpdateStrategy();
    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy();
    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(DaemonSetUpdateStrategy item);
    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.UpdateStrategyNested<A> editUpdateStrategy();
    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy();
    public io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(DaemonSetUpdateStrategy item);
    public interface SelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.SelectorNested<N>> {

            public N and();
            public N endSelector();    }


    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodTemplateSpecFluent<io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.TemplateNested<N>> {

            public N and();
            public N endTemplate();    }


    public interface UpdateStrategyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DaemonSetUpdateStrategyFluent<io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent.UpdateStrategyNested<N>> {

            public N and();
            public N endUpdateStrategy();    }


}
