package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface IPBlockFluent<A extends IPBlockFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getCidr();
    public A withCidr(String cidr);
    public Boolean hasCidr();
    public A withNewCidr(StringBuilder arg1);
    public A withNewCidr(int[] arg1,int arg2,int arg3);
    public A withNewCidr(char[] arg1);
    public A withNewCidr(StringBuffer arg1);
    public A withNewCidr(byte[] arg1,int arg2);
    public A withNewCidr(byte[] arg1);
    public A withNewCidr(char[] arg1,int arg2,int arg3);
    public A withNewCidr(byte[] arg1,int arg2,int arg3);
    public A withNewCidr(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewCidr(String arg1);
    public A addToExcept(int index,String item);
    public A setToExcept(int index,String item);
    public A addToExcept(String... items);
    public A addAllToExcept(Collection<String> items);
    public A removeFromExcept(String... items);
    public A removeAllFromExcept(Collection<String> items);
    public List<String> getExcept();
    public String getExcept(int index);
    public String getFirstExcept();
    public String getLastExcept();
    public String getMatchingExcept(Predicate<String> predicate);
    public Boolean hasMatchingExcept(Predicate<String> predicate);
    public A withExcept(List<String> except);
    public A withExcept(String... except);
    public Boolean hasExcept();
    public A addNewExcept(StringBuilder arg1);
    public A addNewExcept(int[] arg1,int arg2,int arg3);
    public A addNewExcept(char[] arg1);
    public A addNewExcept(StringBuffer arg1);
    public A addNewExcept(byte[] arg1,int arg2);
    public A addNewExcept(byte[] arg1);
    public A addNewExcept(char[] arg1,int arg2,int arg3);
    public A addNewExcept(byte[] arg1,int arg2,int arg3);
    public A addNewExcept(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewExcept(String arg1);
}
