package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class DeploymentRollbackFluentImpl<A extends DeploymentRollbackFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DeploymentRollbackFluent<A> {

    private String apiVersion;
    private String kind;
    private String name;
    private RollbackConfigBuilder rollbackTo;
    private java.util.Map<String,String> updatedAnnotations;

    public DeploymentRollbackFluentImpl() {
    }

    public DeploymentRollbackFluentImpl(DeploymentRollback instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withName(instance.getName()); 
        this.withRollbackTo(instance.getRollbackTo()); 
        this.withUpdatedAnnotations(instance.getUpdatedAnnotations()); 
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(int[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(char[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(byte[] arg1,int arg2) {
        return (A)withApiVersion(new String(arg1, arg2));
    }

    public A withNewApiVersion(byte[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(char[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withApiVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(int[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(char[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(byte[] arg1,int arg2) {
        return (A)withKind(new String(arg1, arg2));
    }

    public A withNewKind(byte[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(char[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKind(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildRollbackTo instead.
 * @return The buildable object.
 */
@Deprecated public RollbackConfig getRollbackTo() {
        return this.rollbackTo!=null?this.rollbackTo.build():null;
    }

    public RollbackConfig buildRollbackTo() {
        return this.rollbackTo!=null?this.rollbackTo.build():null;
    }

    public A withRollbackTo(RollbackConfig rollbackTo) {
        _visitables.get("rollbackTo").remove(this.rollbackTo);
        if (rollbackTo!=null){ this.rollbackTo= new RollbackConfigBuilder(rollbackTo); _visitables.get("rollbackTo").add(this.rollbackTo);} return (A) this;
    }

    public Boolean hasRollbackTo() {
        return this.rollbackTo != null;
    }

    public A withNewRollbackTo(Long revision) {
        return (A)withRollbackTo(new RollbackConfig(revision));
    }

    public io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackFluent.RollbackToNested<A> withNewRollbackTo() {
        return new RollbackToNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackFluent.RollbackToNested<A> withNewRollbackToLike(RollbackConfig item) {
        return new RollbackToNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackFluent.RollbackToNested<A> editRollbackTo() {
        return withNewRollbackToLike(getRollbackTo());
    }

    public io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackFluent.RollbackToNested<A> editOrNewRollbackTo() {
        return withNewRollbackToLike(getRollbackTo() != null ? getRollbackTo(): new RollbackConfigBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackFluent.RollbackToNested<A> editOrNewRollbackToLike(RollbackConfig item) {
        return withNewRollbackToLike(getRollbackTo() != null ? getRollbackTo(): item);
    }

    public A addToUpdatedAnnotations(String key,String value) {
        if(this.updatedAnnotations == null && key != null && value != null) { this.updatedAnnotations = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.updatedAnnotations.put(key, value);} return (A)this;
    }

    public A addToUpdatedAnnotations(java.util.Map<String,String> map) {
        if(this.updatedAnnotations == null && map != null) { this.updatedAnnotations = new LinkedHashMap<String,String>(); }
        if(map != null) { this.updatedAnnotations.putAll(map);} return (A)this;
    }

    public A removeFromUpdatedAnnotations(String key) {
        if(this.updatedAnnotations == null) { return (A) this; }
        if(key != null && this.updatedAnnotations != null) {this.updatedAnnotations.remove(key);} return (A)this;
    }

    public A removeFromUpdatedAnnotations(java.util.Map<String,String> map) {
        if(this.updatedAnnotations == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.updatedAnnotations != null){this.updatedAnnotations.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,String> getUpdatedAnnotations() {
        return this.updatedAnnotations;
    }

    public <K extends Object,V extends Object>A withUpdatedAnnotations(java.util.Map<String,String> updatedAnnotations) {
        if (updatedAnnotations == null) { this.updatedAnnotations =  null;} else {this.updatedAnnotations = new LinkedHashMap<String,String>(updatedAnnotations);} return (A) this;
    }

    public Boolean hasUpdatedAnnotations() {
        return this.updatedAnnotations != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DeploymentRollbackFluentImpl that = (DeploymentRollbackFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (rollbackTo != null ? !rollbackTo.equals(that.rollbackTo) :that.rollbackTo != null) return false;
        if (updatedAnnotations != null ? !updatedAnnotations.equals(that.updatedAnnotations) :that.updatedAnnotations != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  name,  rollbackTo,  updatedAnnotations,  super.hashCode());
    }

    public class RollbackToNestedImpl<N> extends RollbackConfigFluentImpl<io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackFluent.RollbackToNested<N>> implements io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackFluent.RollbackToNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RollbackConfigBuilder builder;

            RollbackToNestedImpl(RollbackConfig item) {
                this.builder = new RollbackConfigBuilder(this, item);
                        
            }

            RollbackToNestedImpl() {
                this.builder = new RollbackConfigBuilder(this);
                        
            }

            public N and() {
                return (N) DeploymentRollbackFluentImpl.this.withRollbackTo(builder.build());
            }

            public N endRollbackTo() {
                return and();
            }
    }


}
