package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface NetworkPolicyListFluent<A extends NetworkPolicyListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,NetworkPolicy item);
    public A setToItems(int index,NetworkPolicy item);
    public A addToItems(NetworkPolicy... items);
    public A addAllToItems(Collection<NetworkPolicy> items);
    public A removeFromItems(NetworkPolicy... items);
    public A removeAllFromItems(Collection<NetworkPolicy> items);
    public A removeMatchingFromItems(Predicate<NetworkPolicyBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<NetworkPolicy> getItems();
    public List<NetworkPolicy> buildItems();
    public NetworkPolicy buildItem(int index);
    public NetworkPolicy buildFirstItem();
    public NetworkPolicy buildLastItem();
    public NetworkPolicy buildMatchingItem(Predicate<NetworkPolicyBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<NetworkPolicyBuilder> predicate);
    public A withItems(List<NetworkPolicy> items);
    public A withItems(NetworkPolicy... items);
    public Boolean hasItems();
    public NetworkPolicyListFluent.ItemsNested<A> addNewItem();
    public NetworkPolicyListFluent.ItemsNested<A> addNewItemLike(NetworkPolicy item);
    public NetworkPolicyListFluent.ItemsNested<A> setNewItemLike(int index,NetworkPolicy item);
    public NetworkPolicyListFluent.ItemsNested<A> editItem(int index);
    public NetworkPolicyListFluent.ItemsNested<A> editFirstItem();
    public NetworkPolicyListFluent.ItemsNested<A> editLastItem();
    public NetworkPolicyListFluent.ItemsNested<A> editMatchingItem(Predicate<NetworkPolicyBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetworkPolicyFluent<NetworkPolicyListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
