package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class DaemonSetListFluentImpl<A extends DaemonSetListFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DaemonSetListFluent<A> {

    private String apiVersion;
    private List<DaemonSetBuilder> items =  new ArrayList<DaemonSetBuilder>();
    private String kind;
    private ListMeta metadata;

    public DaemonSetListFluentImpl() { 
    }


    public DaemonSetListFluentImpl(DaemonSetList instance) { 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
    }


    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A addToItems(int index,DaemonSet item) {
        if (this.items == null) {this.items = new ArrayList<DaemonSetBuilder>();}
        DaemonSetBuilder builder = new DaemonSetBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,DaemonSet item) {
        if (this.items == null) {this.items = new ArrayList<DaemonSetBuilder>();}
        DaemonSetBuilder builder = new DaemonSetBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToItems(DaemonSet... items) {
        if (this.items == null) {this.items = new ArrayList<DaemonSetBuilder>();}
        for (DaemonSet item : items) {DaemonSetBuilder builder = new DaemonSetBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<DaemonSet> items) {
        if (this.items == null) {this.items = new ArrayList<DaemonSetBuilder>();}
        for (DaemonSet item : items) {DaemonSetBuilder builder = new DaemonSetBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(DaemonSet... items) {
        for (DaemonSet item : items) {DaemonSetBuilder builder = new DaemonSetBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<DaemonSet> items) {
        for (DaemonSet item : items) {DaemonSetBuilder builder = new DaemonSetBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromItems(Predicate<DaemonSetBuilder> predicate) {
        if (items == null) return (A) this;
        final Iterator<DaemonSetBuilder> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          DaemonSetBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<DaemonSet> getItems() {
        return build(items);
    }

    public List<DaemonSet> buildItems() {
        return build(items);
    }

    public DaemonSet buildItem(int index) {
        return this.items.get(index).build();
    }

    public DaemonSet buildFirstItem() {
        return this.items.get(0).build();
    }

    public DaemonSet buildLastItem() {
        return this.items.get(items.size() - 1).build();
    }

    public DaemonSet buildMatchingItem(Predicate<DaemonSetBuilder> predicate) {
        for (DaemonSetBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingItem(Predicate<DaemonSetBuilder> predicate) {
        for (DaemonSetBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withItems(List<DaemonSet> items) {
        if (this.items != null) { _visitables.get("items").removeAll(this.items);}
        if (items != null) {this.items = new ArrayList<DaemonSetBuilder>(); for (DaemonSet item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(DaemonSet... items) {
        if (this.items != null) {this.items.clear();}
        if (items != null) {for (DaemonSet item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems() {
        return items != null && !items.isEmpty();
    }

    public DaemonSetListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    public DaemonSetListFluent.ItemsNested<A> addNewItemLike(DaemonSet item) {
        return new ItemsNestedImpl(-1, item);
    }

    public DaemonSetListFluent.ItemsNested<A> setNewItemLike(int index,DaemonSet item) {
        return new ItemsNestedImpl(index, item);
    }

    public DaemonSetListFluent.ItemsNested<A> editItem(int index) {
        if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
        return setNewItemLike(index, buildItem(index));
    }

    public DaemonSetListFluent.ItemsNested<A> editFirstItem() {
        if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
        return setNewItemLike(0, buildItem(0));
    }

    public DaemonSetListFluent.ItemsNested<A> editLastItem() {
        int index = items.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
        return setNewItemLike(index, buildItem(index));
    }

    public DaemonSetListFluent.ItemsNested<A> editMatchingItem(Predicate<DaemonSetBuilder> predicate) {
        int index = -1;
        for (int i=0;i<items.size();i++) { 
        if (predicate.test(items.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
        return setNewItemLike(index, buildItem(index));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public ListMeta getMetadata() {
        return this.metadata;
    }

    public A withMetadata(ListMeta metadata) {
        this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
        return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DaemonSetListFluentImpl that = (DaemonSetListFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (items != null ? !items.equals(that.items) :that.items != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  super.hashCode());
    }

    public class ItemsNestedImpl<N> extends DaemonSetFluentImpl<DaemonSetListFluent.ItemsNested<N>> implements DaemonSetListFluent.ItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DaemonSetBuilder builder;
        private final int index;

        ItemsNestedImpl(int index,DaemonSet item) {
            this.index = index;
            this.builder = new DaemonSetBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new DaemonSetBuilder(this);
        }

        public N and() {
             return (N) DaemonSetListFluentImpl.this.setToItems(index,builder.build());
        }

        public N endItem() {
             return and();
        }
    }


}
