package io.fabric8.kubernetes.api.model.events.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EventListBuilder extends EventListFluentImpl<EventListBuilder> implements VisitableBuilder<EventList,EventListBuilder>{
  public EventListBuilder() {
    this(false);
  }
  public EventListBuilder(Boolean validationEnabled) {
    this(new EventList(), validationEnabled);
  }
  public EventListBuilder(EventListFluent<?> fluent) {
    this(fluent, false);
  }
  public EventListBuilder(EventListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EventList(), validationEnabled);
  }
  public EventListBuilder(EventListFluent<?> fluent,EventList instance) {
    this(fluent, instance, false);
  }
  public EventListBuilder(EventListFluent<?> fluent,EventList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EventListBuilder(EventList instance) {
    this(instance,false);
  }
  public EventListBuilder(EventList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  EventListFluent<?> fluent;
  Boolean validationEnabled;
  public EventList build() {
    EventList buildable = new EventList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}