package io.fabric8.kubernetes.api.model.events.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EventListBuilder extends EventListFluent<EventListBuilder> implements VisitableBuilder<EventList,EventListBuilder>{
  public EventListBuilder() {
    this(new EventList());
  }
  
  public EventListBuilder(EventListFluent<?> fluent) {
    this(fluent, new EventList());
  }
  
  public EventListBuilder(EventListFluent<?> fluent,EventList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EventListBuilder(EventList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EventListFluent<?> fluent;
  
  public EventList build() {
    EventList buildable = new EventList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}