package io.fabric8.kubernetes.api.model.events;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface EventListFluent<A extends EventListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Event item);
    public A setToItems(int index,Event item);
    public A addToItems(Event... items);
    public A addAllToItems(Collection<Event> items);
    public A removeFromItems(Event... items);
    public A removeAllFromItems(Collection<Event> items);
    public A removeMatchingFromItems(Predicate<EventBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Event> getItems();
    public List<Event> buildItems();
    public Event buildItem(int index);
    public Event buildFirstItem();
    public Event buildLastItem();
    public Event buildMatchingItem(Predicate<EventBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<EventBuilder> predicate);
    public A withItems(List<Event> items);
    public A withItems(Event... items);
    public Boolean hasItems();
    public EventListFluent.ItemsNested<A> addNewItem();
    public EventListFluent.ItemsNested<A> addNewItemLike(Event item);
    public EventListFluent.ItemsNested<A> setNewItemLike(int index,Event item);
    public EventListFluent.ItemsNested<A> editItem(int index);
    public EventListFluent.ItemsNested<A> editFirstItem();
    public EventListFluent.ItemsNested<A> editLastItem();
    public EventListFluent.ItemsNested<A> editMatchingItem(Predicate<EventBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EventFluent<EventListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
