package io.fabric8.kubernetes.api.model.events;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EventListBuilder extends EventListFluentImpl<EventListBuilder> implements VisitableBuilder<EventList,EventListBuilder> {

    EventListFluent<?> fluent;
    Boolean validationEnabled;

    public EventListBuilder() {
        this(true);
    }

    public EventListBuilder(Boolean validationEnabled) {
        this(new EventList(), validationEnabled);
    }

    public EventListBuilder(EventListFluent<?> fluent) {
        this(fluent, true);
    }

    public EventListBuilder(EventListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new EventList(), validationEnabled);
    }

    public EventListBuilder(EventListFluent<?> fluent,EventList instance) {
        this(fluent, instance, true);
    }

    public EventListBuilder(EventListFluent<?> fluent,EventList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public EventListBuilder(EventList instance) {
        this(instance,true);
    }

    public EventListBuilder(EventList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public EventList build() {
        EventList buildable = new EventList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EventListBuilder that = (EventListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
