package io.fabric8.kubernetes.api.model.discovery.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointPortBuilder extends EndpointPortFluentImpl<EndpointPortBuilder> implements VisitableBuilder<EndpointPort,EndpointPortBuilder>{
  public EndpointPortBuilder() {
    this(false);
  }
  public EndpointPortBuilder(Boolean validationEnabled) {
    this(new EndpointPort(), validationEnabled);
  }
  public EndpointPortBuilder(EndpointPortFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointPortBuilder(EndpointPortFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EndpointPort(), validationEnabled);
  }
  public EndpointPortBuilder(EndpointPortFluent<?> fluent,EndpointPort instance) {
    this(fluent, instance, false);
  }
  public EndpointPortBuilder(EndpointPortFluent<?> fluent,EndpointPort instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAppProtocol(instance.getAppProtocol());
      fluent.withName(instance.getName());
      fluent.withPort(instance.getPort());
      fluent.withProtocol(instance.getProtocol());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EndpointPortBuilder(EndpointPort instance) {
    this(instance,false);
  }
  public EndpointPortBuilder(EndpointPort instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAppProtocol(instance.getAppProtocol());
      this.withName(instance.getName());
      this.withPort(instance.getPort());
      this.withProtocol(instance.getProtocol());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EndpointPortFluent<?> fluent;
  Boolean validationEnabled;
  public EndpointPort build() {
    EndpointPort buildable = new EndpointPort(fluent.getAppProtocol(),fluent.getName(),fluent.getPort(),fluent.getProtocol());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}