package io.fabric8.kubernetes.api.model.discovery.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointSliceListBuilder extends EndpointSliceListFluentImpl<EndpointSliceListBuilder> implements VisitableBuilder<EndpointSliceList,io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceListBuilder>{
  public EndpointSliceListBuilder() {
    this(false);
  }
  public EndpointSliceListBuilder(Boolean validationEnabled) {
    this(new EndpointSliceList(), validationEnabled);
  }
  public EndpointSliceListBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceListFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointSliceListBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new EndpointSliceList(), validationEnabled);
  }
  public EndpointSliceListBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceListFluent<?> fluent,io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceList instance) {
    this(fluent, instance, false);
  }
  public EndpointSliceListBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceListFluent<?> fluent,io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EndpointSliceListBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceList instance) {
    this(instance,false);
  }
  public EndpointSliceListBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceList build() {
    EndpointSliceList buildable = new EndpointSliceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}