package io.fabric8.kubernetes.api.model.discovery.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EndpointSliceFluentImpl<A extends EndpointSliceFluent<A>> extends BaseFluent<A> implements EndpointSliceFluent<A>{
  public EndpointSliceFluentImpl() {
  }
  public EndpointSliceFluentImpl(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSlice instance) {
    this.withAddressType(instance.getAddressType()); 
    this.withApiVersion(instance.getApiVersion()); 
    this.withEndpoints(instance.getEndpoints()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withPorts(instance.getPorts()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String addressType;
  private java.lang.String apiVersion;
  private ArrayList<EndpointBuilder> endpoints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder>();
  private java.lang.String kind;
  private ObjectMetaBuilder metadata;
  private java.util.ArrayList<EndpointPortBuilder> ports = new java.util.ArrayList<EndpointPortBuilder>();
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getAddressType() {
    return this.addressType;
  }
  public A withAddressType(java.lang.String addressType) {
    this.addressType=addressType; return (A) this;
  }
  public Boolean hasAddressType() {
    return this.addressType != null;
  }
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToEndpoints(Integer index,io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint item) {
    if (this.endpoints == null) {this.endpoints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder>();}
    io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder builder = new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder(item);_visitables.get("endpoints").add(index >= 0 ? index : _visitables.get("endpoints").size(), builder);this.endpoints.add(index >= 0 ? index : endpoints.size(), builder); return (A)this;
  }
  public A setToEndpoints(java.lang.Integer index,io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint item) {
    if (this.endpoints == null) {this.endpoints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder>();}
    io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder builder = new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder(item);
    if (index < 0 || index >= _visitables.get("endpoints").size()) { _visitables.get("endpoints").add(builder); } else { _visitables.get("endpoints").set(index, builder);}
    if (index < 0 || index >= endpoints.size()) { endpoints.add(builder); } else { endpoints.set(index, builder);}
     return (A)this;
  }
  public A addToEndpoints(io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint... items) {
    if (this.endpoints == null) {this.endpoints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder>();}
    for (io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint item : items) {io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder builder = new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
  }
  public A addAllToEndpoints(Collection<io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint> items) {
    if (this.endpoints == null) {this.endpoints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder>();}
    for (io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint item : items) {io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder builder = new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
  }
  public A removeFromEndpoints(io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint... items) {
    for (io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint item : items) {io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder builder = new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder(item);_visitables.get("endpoints").remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
  }
  public A removeAllFromEndpoints(java.util.Collection<io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint> items) {
    for (io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint item : items) {io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder builder = new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder(item);_visitables.get("endpoints").remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEndpoints(Predicate<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder> predicate) {
    if (endpoints == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder> each = endpoints.iterator();
    final List visitables = _visitables.get("endpoints");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildEndpoints instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint> getEndpoints() {
    return endpoints != null ? build(endpoints) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint> buildEndpoints() {
    return endpoints != null ? build(endpoints) : null;
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint buildEndpoint(java.lang.Integer index) {
    return this.endpoints.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint buildFirstEndpoint() {
    return this.endpoints.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint buildLastEndpoint() {
    return this.endpoints.get(endpoints.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint buildMatchingEndpoint(java.util.function.Predicate<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder item: endpoints) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingEndpoint(java.util.function.Predicate<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder item: endpoints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEndpoints(java.util.List<io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint> endpoints) {
    if (this.endpoints != null) { _visitables.get("endpoints").removeAll(this.endpoints);}
    if (endpoints != null) {this.endpoints = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint item : endpoints){this.addToEndpoints(item);}} else { this.endpoints = null;} return (A) this;
  }
  public A withEndpoints(io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint... endpoints) {
    if (this.endpoints != null) {this.endpoints.clear();}
    if (endpoints != null) {for (io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint item :endpoints){ this.addToEndpoints(item);}} return (A) this;
  }
  public java.lang.Boolean hasEndpoints() {
    return endpoints != null && !endpoints.isEmpty();
  }
  public EndpointSliceFluent.EndpointsNested<A> addNewEndpoint() {
    return new EndpointSliceFluentImpl.EndpointsNestedImpl();
  }
  public EndpointSliceFluent.EndpointsNested<A> addNewEndpointLike(io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint item) {
    return new EndpointSliceFluentImpl.EndpointsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.EndpointsNested<A> setNewEndpointLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint item) {
    return new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluentImpl.EndpointsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.EndpointsNested<A> editEndpoint(java.lang.Integer index) {
    if (endpoints.size() <= index) throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.EndpointsNested<A> editFirstEndpoint() {
    if (endpoints.size() == 0) throw new RuntimeException("Can't edit first endpoints. The list is empty.");
    return setNewEndpointLike(0, buildEndpoint(0));
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.EndpointsNested<A> editLastEndpoint() {
    int index = endpoints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last endpoints. The list is empty.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.EndpointsNested<A> editMatchingEndpoint(java.util.function.Predicate<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder> predicate) {
    int index = -1;
    for (int i=0;i<endpoints.size();i++) { 
    if (predicate.test(endpoints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching endpoints. No match found.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public EndpointSliceFluent.MetadataNested<A> withNewMetadata() {
    return new EndpointSliceFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToPorts(java.lang.Integer index,io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort item) {
    if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder>();}
    io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder builder = new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder(item);_visitables.get("ports").add(index >= 0 ? index : _visitables.get("ports").size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
  }
  public A setToPorts(java.lang.Integer index,io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort item) {
    if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder>();}
    io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder builder = new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder(item);
    if (index < 0 || index >= _visitables.get("ports").size()) { _visitables.get("ports").add(builder); } else { _visitables.get("ports").set(index, builder);}
    if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
     return (A)this;
  }
  public A addToPorts(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort... items) {
    if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder>();}
    for (io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort item : items) {io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder builder = new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A addAllToPorts(java.util.Collection<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort> items) {
    if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder>();}
    for (io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort item : items) {io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder builder = new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A removeFromPorts(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort... items) {
    for (io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort item : items) {io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder builder = new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
  }
  public A removeAllFromPorts(java.util.Collection<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort> items) {
    for (io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort item : items) {io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder builder = new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPorts(java.util.function.Predicate<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder> predicate) {
    if (ports == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder> each = ports.iterator();
    final List visitables = _visitables.get("ports");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPorts instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort> getPorts() {
    return ports != null ? build(ports) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort> buildPorts() {
    return ports != null ? build(ports) : null;
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort buildPort(java.lang.Integer index) {
    return this.ports.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort buildFirstPort() {
    return this.ports.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort buildLastPort() {
    return this.ports.get(ports.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort buildMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder item: ports) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder item: ports) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPorts(java.util.List<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort> ports) {
    if (this.ports != null) { _visitables.get("ports").removeAll(this.ports);}
    if (ports != null) {this.ports = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
  }
  public A withPorts(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort... ports) {
    if (this.ports != null) {this.ports.clear();}
    if (ports != null) {for (io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort item :ports){ this.addToPorts(item);}} return (A) this;
  }
  public java.lang.Boolean hasPorts() {
    return ports != null && !ports.isEmpty();
  }
  public A addNewPort(java.lang.String appProtocol,java.lang.String name,java.lang.Integer port,java.lang.String protocol) {
    return (A)addToPorts(new EndpointPort(appProtocol, name, port, protocol));
  }
  public EndpointSliceFluent.PortsNested<A> addNewPort() {
    return new EndpointSliceFluentImpl.PortsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.PortsNested<A> addNewPortLike(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort item) {
    return new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluentImpl.PortsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.PortsNested<A> setNewPortLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort item) {
    return new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluentImpl.PortsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.PortsNested<A> editPort(java.lang.Integer index) {
    if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
    return setNewPortLike(index, buildPort(index));
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.PortsNested<A> editFirstPort() {
    if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
    return setNewPortLike(0, buildPort(0));
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.PortsNested<A> editLastPort() {
    int index = ports.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
    return setNewPortLike(index, buildPort(index));
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.PortsNested<A> editMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ports.size();i++) { 
    if (predicate.test(ports.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
    return setNewPortLike(index, buildPort(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EndpointSliceFluentImpl that = (EndpointSliceFluentImpl) o;
    if (addressType != null ? !addressType.equals(that.addressType) :that.addressType != null) return false;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (endpoints != null ? !endpoints.equals(that.endpoints) :that.endpoints != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(addressType,  apiVersion,  endpoints,  kind,  metadata,  ports,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (addressType != null) { sb.append("addressType:"); sb.append(addressType + ","); }
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (endpoints != null && !endpoints.isEmpty()) { sb.append("endpoints:"); sb.append(endpoints + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (ports != null && !ports.isEmpty()) { sb.append("ports:"); sb.append(ports + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class EndpointsNestedImpl<N> extends EndpointFluentImpl<EndpointSliceFluent.EndpointsNested<N>> implements EndpointSliceFluent.EndpointsNested<N>,Nested<N>{
    EndpointsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint item) {
      this.index = index;
      this.builder = new EndpointBuilder(this, item);
    }
    EndpointsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder(this);
    }
    io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) EndpointSliceFluentImpl.this.setToEndpoints(index,builder.build());
    }
    public N endEndpoint() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<EndpointSliceFluent.MetadataNested<N>> implements io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) EndpointSliceFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class PortsNestedImpl<N> extends EndpointPortFluentImpl<EndpointSliceFluent.PortsNested<N>> implements io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent.PortsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PortsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort item) {
      this.index = index;
      this.builder = new EndpointPortBuilder(this, item);
    }
    PortsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder(this);
    }
    io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) EndpointSliceFluentImpl.this.setToPorts(index,builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  
}