package io.fabric8.kubernetes.api.model.discovery.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointConditionsBuilder extends EndpointConditionsFluentImpl<EndpointConditionsBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditions,io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditionsBuilder>{
  public EndpointConditionsBuilder() {
    this(false);
  }
  public EndpointConditionsBuilder(Boolean validationEnabled) {
    this(new EndpointConditions(), validationEnabled);
  }
  public EndpointConditionsBuilder(EndpointConditionsFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointConditionsBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditionsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new EndpointConditions(), validationEnabled);
  }
  public EndpointConditionsBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditionsFluent<?> fluent,io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditions instance) {
    this(fluent, instance, false);
  }
  public EndpointConditionsBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditionsFluent<?> fluent,io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditions instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withReady(instance.getReady()); 
    fluent.withServing(instance.getServing()); 
    fluent.withTerminating(instance.getTerminating()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EndpointConditionsBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditions instance) {
    this(instance,false);
  }
  public EndpointConditionsBuilder(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditions instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withReady(instance.getReady()); 
    this.withServing(instance.getServing()); 
    this.withTerminating(instance.getTerminating()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditionsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditions build() {
    EndpointConditions buildable = new EndpointConditions(fluent.getReady(),fluent.getServing(),fluent.getTerminating());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}