package io.fabric8.kubernetes.api.model.discovery.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointPortBuilder extends EndpointPortFluentImpl<EndpointPortBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.discovery.v1.EndpointPort,io.fabric8.kubernetes.api.model.discovery.v1.EndpointPortBuilder>{
  public EndpointPortBuilder() {
    this(false);
  }
  public EndpointPortBuilder(Boolean validationEnabled) {
    this(new EndpointPort(), validationEnabled);
  }
  public EndpointPortBuilder(EndpointPortFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointPortBuilder(io.fabric8.kubernetes.api.model.discovery.v1.EndpointPortFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new EndpointPort(), validationEnabled);
  }
  public EndpointPortBuilder(io.fabric8.kubernetes.api.model.discovery.v1.EndpointPortFluent<?> fluent,io.fabric8.kubernetes.api.model.discovery.v1.EndpointPort instance) {
    this(fluent, instance, false);
  }
  public EndpointPortBuilder(io.fabric8.kubernetes.api.model.discovery.v1.EndpointPortFluent<?> fluent,io.fabric8.kubernetes.api.model.discovery.v1.EndpointPort instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAppProtocol(instance.getAppProtocol()); 
    fluent.withName(instance.getName()); 
    fluent.withPort(instance.getPort()); 
    fluent.withProtocol(instance.getProtocol()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EndpointPortBuilder(io.fabric8.kubernetes.api.model.discovery.v1.EndpointPort instance) {
    this(instance,false);
  }
  public EndpointPortBuilder(io.fabric8.kubernetes.api.model.discovery.v1.EndpointPort instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAppProtocol(instance.getAppProtocol()); 
    this.withName(instance.getName()); 
    this.withPort(instance.getPort()); 
    this.withProtocol(instance.getProtocol()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.discovery.v1.EndpointPortFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.discovery.v1.EndpointPort build() {
    EndpointPort buildable = new EndpointPort(fluent.getAppProtocol(),fluent.getName(),fluent.getPort(),fluent.getProtocol());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}