package io.fabric8.kubernetes.api.model.discovery.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointBuilder extends EndpointFluentImpl<EndpointBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.discovery.v1.Endpoint,EndpointBuilder>{
  public EndpointBuilder() {
    this(false);
  }
  public EndpointBuilder(Boolean validationEnabled) {
    this(new Endpoint(), validationEnabled);
  }
  public EndpointBuilder(io.fabric8.kubernetes.api.model.discovery.v1.EndpointFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointBuilder(io.fabric8.kubernetes.api.model.discovery.v1.EndpointFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Endpoint(), validationEnabled);
  }
  public EndpointBuilder(io.fabric8.kubernetes.api.model.discovery.v1.EndpointFluent<?> fluent,io.fabric8.kubernetes.api.model.discovery.v1.Endpoint instance) {
    this(fluent, instance, false);
  }
  public EndpointBuilder(io.fabric8.kubernetes.api.model.discovery.v1.EndpointFluent<?> fluent,io.fabric8.kubernetes.api.model.discovery.v1.Endpoint instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAddresses(instance.getAddresses()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withDeprecatedTopology(instance.getDeprecatedTopology()); 
    fluent.withHints(instance.getHints()); 
    fluent.withHostname(instance.getHostname()); 
    fluent.withNodeName(instance.getNodeName()); 
    fluent.withTargetRef(instance.getTargetRef()); 
    fluent.withZone(instance.getZone()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EndpointBuilder(io.fabric8.kubernetes.api.model.discovery.v1.Endpoint instance) {
    this(instance,false);
  }
  public EndpointBuilder(io.fabric8.kubernetes.api.model.discovery.v1.Endpoint instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAddresses(instance.getAddresses()); 
    this.withConditions(instance.getConditions()); 
    this.withDeprecatedTopology(instance.getDeprecatedTopology()); 
    this.withHints(instance.getHints()); 
    this.withHostname(instance.getHostname()); 
    this.withNodeName(instance.getNodeName()); 
    this.withTargetRef(instance.getTargetRef()); 
    this.withZone(instance.getZone()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.discovery.v1.EndpointFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.discovery.v1.Endpoint build() {
    Endpoint buildable = new Endpoint(fluent.getAddresses(),fluent.getConditions(),fluent.getDeprecatedTopology(),fluent.getHints(),fluent.getHostname(),fluent.getNodeName(),fluent.getTargetRef(),fluent.getZone());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}