package io.fabric8.kubernetes.api.model.discovery.v1beta1;

import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class EndpointFluentImpl<A extends io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent<A>{
  public EndpointFluentImpl() {
  }
  public EndpointFluentImpl(io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint instance) {
    this.withAddresses(instance.getAddresses()); 
    this.withConditions(instance.getConditions()); 
    this.withHints(instance.getHints()); 
    this.withHostname(instance.getHostname()); 
    this.withNodeName(instance.getNodeName()); 
    this.withTargetRef(instance.getTargetRef()); 
    this.withTopology(instance.getTopology()); 
  }
  private java.util.List<java.lang.String> addresses = new java.util.ArrayList<java.lang.String>();
  private io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditionsBuilder conditions;
  private io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointHintsBuilder hints;
  private java.lang.String hostname;
  private java.lang.String nodeName;
  private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder targetRef;
  private java.util.Map<java.lang.String,java.lang.String> topology;
  public A addToAddresses(java.lang.Integer index,java.lang.String item) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<java.lang.String>();}
    this.addresses.add(index, item);
    return (A)this;
  }
  public A setToAddresses(java.lang.Integer index,java.lang.String item) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<java.lang.String>();}
    this.addresses.set(index, item); return (A)this;
  }
  public A addToAddresses(java.lang.String... items) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.addresses.add(item);} return (A)this;
  }
  public A addAllToAddresses(java.util.Collection<java.lang.String> items) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.addresses.add(item);} return (A)this;
  }
  public A removeFromAddresses(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.addresses!= null){ this.addresses.remove(item);}} return (A)this;
  }
  public A removeAllFromAddresses(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.addresses!= null){ this.addresses.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getAddresses() {
    return this.addresses;
  }
  public java.lang.String getAddress(java.lang.Integer index) {
    return this.addresses.get(index);
  }
  public java.lang.String getFirstAddress() {
    return this.addresses.get(0);
  }
  public java.lang.String getLastAddress() {
    return this.addresses.get(addresses.size() - 1);
  }
  public java.lang.String getMatchingAddress(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: addresses) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingAddress(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: addresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAddresses(java.util.List<java.lang.String> addresses) {
    if (addresses != null) {this.addresses = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
  }
  public A withAddresses(java.lang.String... addresses) {
    if (this.addresses != null) {this.addresses.clear();}
    if (addresses != null) {for (java.lang.String item :addresses){ this.addToAddresses(item);}} return (A) this;
  }
  public java.lang.Boolean hasAddresses() {
    return addresses != null && !addresses.isEmpty();
  }
  public A addNewAddress(java.lang.String arg0) {
    return (A)addToAddresses(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditions getConditions() {
    return this.conditions!=null?this.conditions.build():null;
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditions buildConditions() {
    return this.conditions!=null?this.conditions.build():null;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditions conditions) {
    _visitables.get("conditions").remove(this.conditions);
    if (conditions!=null){ this.conditions= new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditionsBuilder(conditions); _visitables.get("conditions").add(this.conditions);} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return this.conditions != null;
  }
  public A withNewConditions(java.lang.Boolean ready,java.lang.Boolean serving,java.lang.Boolean terminating) {
    return (A)withConditions(new EndpointConditions(ready, serving, terminating));
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.ConditionsNested<A> withNewConditions() {
    return new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluentImpl.ConditionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.ConditionsNested<A> withNewConditionsLike(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditions item) {
    return new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluentImpl.ConditionsNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.ConditionsNested<A> editConditions() {
    return withNewConditionsLike(getConditions());
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.ConditionsNested<A> editOrNewConditions() {
    return withNewConditionsLike(getConditions() != null ? getConditions(): new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditionsBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.ConditionsNested<A> editOrNewConditionsLike(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditions item) {
    return withNewConditionsLike(getConditions() != null ? getConditions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildHints instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointHints getHints() {
    return this.hints!=null?this.hints.build():null;
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointHints buildHints() {
    return this.hints!=null?this.hints.build():null;
  }
  public A withHints(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointHints hints) {
    _visitables.get("hints").remove(this.hints);
    if (hints!=null){ this.hints= new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointHintsBuilder(hints); _visitables.get("hints").add(this.hints);} return (A) this;
  }
  public java.lang.Boolean hasHints() {
    return this.hints != null;
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.HintsNested<A> withNewHints() {
    return new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluentImpl.HintsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.HintsNested<A> withNewHintsLike(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointHints item) {
    return new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluentImpl.HintsNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.HintsNested<A> editHints() {
    return withNewHintsLike(getHints());
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.HintsNested<A> editOrNewHints() {
    return withNewHintsLike(getHints() != null ? getHints(): new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointHintsBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.HintsNested<A> editOrNewHintsLike(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointHints item) {
    return withNewHintsLike(getHints() != null ? getHints(): item);
  }
  public java.lang.String getHostname() {
    return this.hostname;
  }
  public A withHostname(java.lang.String hostname) {
    this.hostname=hostname; return (A) this;
  }
  public java.lang.Boolean hasHostname() {
    return this.hostname != null;
  }
  
  /**
   * Method is deprecated. use withHostname instead.
   */
  @java.lang.Deprecated
  public A withNewHostname(java.lang.String arg0) {
    return (A)withHostname(new String(arg0));
  }
  public java.lang.String getNodeName() {
    return this.nodeName;
  }
  public A withNodeName(java.lang.String nodeName) {
    this.nodeName=nodeName; return (A) this;
  }
  public java.lang.Boolean hasNodeName() {
    return this.nodeName != null;
  }
  
  /**
   * Method is deprecated. use withNodeName instead.
   */
  @java.lang.Deprecated
  public A withNewNodeName(java.lang.String arg0) {
    return (A)withNodeName(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildTargetRef instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectReference getTargetRef() {
    return this.targetRef!=null?this.targetRef.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildTargetRef() {
    return this.targetRef!=null?this.targetRef.build():null;
  }
  public A withTargetRef(io.fabric8.kubernetes.api.model.ObjectReference targetRef) {
    _visitables.get("targetRef").remove(this.targetRef);
    if (targetRef!=null){ this.targetRef= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(targetRef); _visitables.get("targetRef").add(this.targetRef);} return (A) this;
  }
  public java.lang.Boolean hasTargetRef() {
    return this.targetRef != null;
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.TargetRefNested<A> withNewTargetRef() {
    return new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluentImpl.TargetRefNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.TargetRefNested<A> withNewTargetRefLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluentImpl.TargetRefNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.TargetRefNested<A> editTargetRef() {
    return withNewTargetRefLike(getTargetRef());
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.TargetRefNested<A> editOrNewTargetRef() {
    return withNewTargetRefLike(getTargetRef() != null ? getTargetRef(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.TargetRefNested<A> editOrNewTargetRefLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return withNewTargetRefLike(getTargetRef() != null ? getTargetRef(): item);
  }
  public A addToTopology(java.lang.String key,java.lang.String value) {
    if(this.topology == null && key != null && value != null) { this.topology = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
    if(key != null && value != null) {this.topology.put(key, value);} return (A)this;
  }
  public A addToTopology(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.topology == null && map != null) { this.topology = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
    if(map != null) { this.topology.putAll(map);} return (A)this;
  }
  public A removeFromTopology(java.lang.String key) {
    if(this.topology == null) { return (A) this; }
    if(key != null && this.topology != null) {this.topology.remove(key);} return (A)this;
  }
  public A removeFromTopology(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.topology == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.topology != null){this.topology.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getTopology() {
    return this.topology;
  }
  public <K,V>A withTopology(java.util.Map<java.lang.String,java.lang.String> topology) {
    if (topology == null) { this.topology =  null;} else {this.topology = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(topology);} return (A) this;
  }
  public java.lang.Boolean hasTopology() {
    return this.topology != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EndpointFluentImpl that = (EndpointFluentImpl) o;
    if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (hints != null ? !hints.equals(that.hints) :that.hints != null) return false;
    if (hostname != null ? !hostname.equals(that.hostname) :that.hostname != null) return false;
    if (nodeName != null ? !nodeName.equals(that.nodeName) :that.nodeName != null) return false;
    if (targetRef != null ? !targetRef.equals(that.targetRef) :that.targetRef != null) return false;
    if (topology != null ? !topology.equals(that.topology) :that.topology != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(addresses,  conditions,  hints,  hostname,  nodeName,  targetRef,  topology,  super.hashCode());
  }
  public class ConditionsNestedImpl<N> extends io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditionsFluentImpl<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.ConditionsNested<N>> implements io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConditionsNestedImpl(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditions item) {
      this.builder = new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditionsBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditionsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditionsBuilder builder;
    public N and() {
      return (N) EndpointFluentImpl.this.withConditions(builder.build());
    }
    public N endConditions() {
      return and();
    }
    
  }
  public class HintsNestedImpl<N> extends io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointHintsFluentImpl<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.HintsNested<N>> implements io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.HintsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    HintsNestedImpl(io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointHints item) {
      this.builder = new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointHintsBuilder(this, item);
    }
    HintsNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointHintsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointHintsBuilder builder;
    public N and() {
      return (N) EndpointFluentImpl.this.withHints(builder.build());
    }
    public N endHints() {
      return and();
    }
    
  }
  public class TargetRefNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.TargetRefNested<N>> implements io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent.TargetRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TargetRefNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
    }
    TargetRefNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
    public N and() {
      return (N) EndpointFluentImpl.this.withTargetRef(builder.build());
    }
    public N endTargetRef() {
      return and();
    }
    
  }
  
}