package io.fabric8.kubernetes.api.model.discovery.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EndpointSliceBuilder extends io.fabric8.kubernetes.api.model.discovery.v1.EndpointSliceFluentImpl<io.fabric8.kubernetes.api.model.discovery.v1.EndpointSliceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.discovery.v1.EndpointSlice,io.fabric8.kubernetes.api.model.discovery.v1.EndpointSliceBuilder> {

    io.fabric8.kubernetes.api.model.discovery.v1.EndpointSliceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public EndpointSliceBuilder() {
        this(true);
    }

    public EndpointSliceBuilder(java.lang.Boolean validationEnabled) {
        this(new EndpointSlice(), validationEnabled);
    }

    public EndpointSliceBuilder(io.fabric8.kubernetes.api.model.discovery.v1.EndpointSliceFluent<?> fluent) {
        this(fluent, true);
    }

    public EndpointSliceBuilder(io.fabric8.kubernetes.api.model.discovery.v1.EndpointSliceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new EndpointSlice(), validationEnabled);
    }

    public EndpointSliceBuilder(io.fabric8.kubernetes.api.model.discovery.v1.EndpointSliceFluent<?> fluent,io.fabric8.kubernetes.api.model.discovery.v1.EndpointSlice instance) {
        this(fluent, instance, true);
    }

    public EndpointSliceBuilder(io.fabric8.kubernetes.api.model.discovery.v1.EndpointSliceFluent<?> fluent,io.fabric8.kubernetes.api.model.discovery.v1.EndpointSlice instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAddressType(instance.getAddressType()); 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withEndpoints(instance.getEndpoints()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withPorts(instance.getPorts()); 
        this.validationEnabled = validationEnabled; 
    }

    public EndpointSliceBuilder(io.fabric8.kubernetes.api.model.discovery.v1.EndpointSlice instance) {
        this(instance,true);
    }

    public EndpointSliceBuilder(io.fabric8.kubernetes.api.model.discovery.v1.EndpointSlice instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAddressType(instance.getAddressType()); 
        this.withApiVersion(instance.getApiVersion()); 
        this.withEndpoints(instance.getEndpoints()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withPorts(instance.getPorts()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.discovery.v1.EndpointSlice build() {
        EndpointSlice buildable = new EndpointSlice(fluent.getAddressType(),fluent.getApiVersion(),fluent.getEndpoints(),fluent.getKind(),fluent.getMetadata(),fluent.getPorts());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EndpointSliceBuilder that = (EndpointSliceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
